/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public final class ChangePropertyKey
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename.", example="management.metrics.binders.files.enabled")
    private final String oldPropertyKey;
    @Option(displayName="New property key", description="The new name for the key identified by `oldPropertyKey`.", example="management.metrics.enable.process.files")
    private final String newPropertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the `oldPropertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    private final @Nullable Boolean relaxedBinding;
    @Option(displayName="Regex", description="Default false. If enabled, `oldPropertyKey` will be interpreted as a Regular Expression, and capture group contents will be available in `newPropertyKey`", required=false)
    private final @Nullable Boolean regex;

    public String getDisplayName() {
        return "Change property key";
    }

    public String getDescription() {
        return "Change a property key leaving the value intact.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyKeyVisitor<ExecutionContext>();
    }

    @Generated
    public ChangePropertyKey(String oldPropertyKey, String newPropertyKey, @Nullable Boolean relaxedBinding, @Nullable Boolean regex) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
        this.relaxedBinding = relaxedBinding;
        this.regex = regex;
    }

    @Generated
    public String getOldPropertyKey() {
        return this.oldPropertyKey;
    }

    @Generated
    public String getNewPropertyKey() {
        return this.newPropertyKey;
    }

    @Generated
    public @Nullable Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Generated
    public @Nullable Boolean getRegex() {
        return this.regex;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePropertyKey(oldPropertyKey=" + this.getOldPropertyKey() + ", newPropertyKey=" + this.getNewPropertyKey() + ", relaxedBinding=" + this.getRelaxedBinding() + ", regex=" + this.getRegex() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKey)) {
            return false;
        }
        ChangePropertyKey other = (ChangePropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$oldPropertyKey = this.getOldPropertyKey();
        String other$oldPropertyKey = other.getOldPropertyKey();
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.getNewPropertyKey();
        String other$newPropertyKey = other.getNewPropertyKey();
        return !(this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePropertyKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $oldPropertyKey = this.getOldPropertyKey();
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.getNewPropertyKey();
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        return result;
    }

    public class ChangePropertyKeyVisitor<P>
    extends PropertiesVisitor<P> {
        @Override
        public Properties visitEntry(Properties.Entry entry, P p) {
            if (Boolean.TRUE.equals(ChangePropertyKey.this.regex)) {
                if (!Boolean.FALSE.equals(ChangePropertyKey.this.relaxedBinding) ? NameCaseConvention.matchesRegexRelaxedBinding((String)entry.getKey(), (String)ChangePropertyKey.this.oldPropertyKey) : entry.getKey().matches(ChangePropertyKey.this.oldPropertyKey)) {
                    entry = entry.withKey(entry.getKey().replaceFirst(ChangePropertyKey.this.oldPropertyKey, ChangePropertyKey.this.newPropertyKey)).withPrefix(entry.getPrefix());
                }
            } else if (!Boolean.FALSE.equals(ChangePropertyKey.this.relaxedBinding) ? NameCaseConvention.equalsRelaxedBinding((String)entry.getKey(), (String)ChangePropertyKey.this.oldPropertyKey) : entry.getKey().equals(ChangePropertyKey.this.oldPropertyKey)) {
                entry = entry.withKey(ChangePropertyKey.this.newPropertyKey).withPrefix(entry.getPrefix());
            }
            return super.visitEntry(entry, p);
        }
    }
}

