/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeTagAttributeVisitor<P>
extends XmlVisitor<P> {
    private final XPathMatcher elementName;
    private final String attributeName;
    @Nullable
    private final String oldValue;
    private final String newValue;

    @Override
    public Xml visitTag(Xml.Tag tag, P p) {
        Xml.Tag t = (Xml.Tag)super.visitTag(tag, p);
        if (this.elementName.matches(this.getCursor())) {
            t = t.withAttributes(ListUtils.map(t.getAttributes(), a -> (Xml.Attribute)this.visitChosenElementAttribute((Xml.Attribute)a)));
        }
        return t;
    }

    public Xml visitChosenElementAttribute(Xml.Attribute attribute) {
        if (!attribute.getKeyAsString().equals(this.attributeName)) {
            return attribute;
        }
        if (this.oldValue != null && !attribute.getValueAsString().startsWith(this.oldValue)) {
            return attribute;
        }
        String changedValue = this.oldValue != null ? attribute.getValueAsString().replace(this.oldValue, this.newValue) : this.newValue;
        return attribute.withValue(new Xml.Attribute.Value(attribute.getId(), "", attribute.getMarkers(), attribute.getValue().getQuote(), changedValue));
    }

    public ChangeTagAttributeVisitor(XPathMatcher elementName, String attributeName, @Nullable String oldValue, String newValue) {
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public XPathMatcher getElementName() {
        return this.elementName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @NonNull
    public String toString() {
        return "ChangeTagAttributeVisitor(elementName=" + this.getElementName() + ", attributeName=" + this.getAttributeName() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTagAttributeVisitor)) {
            return false;
        }
        ChangeTagAttributeVisitor other = (ChangeTagAttributeVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XPathMatcher this$elementName = this.getElementName();
        XPathMatcher other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeTagAttributeVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        XPathMatcher $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }
}

