/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.function.Predicate;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class FilterTagChildrenVisitor<T>
extends XmlVisitor<T> {
    public final Xml.Tag scope;
    public final Predicate<Content> childTest;

    @Override
    public Xml visitTag(Xml.Tag tag, T ctx) {
        Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
        if (this.scope.isScope(t)) {
            t = t.withContent(ListUtils.map(t.getContent(), it -> {
                if (this.childTest.test((Content)it)) {
                    return it;
                }
                return null;
            }));
        }
        return t;
    }

    public static Xml.Tag filterChildren(Xml.Tag parent, Predicate<Content> childTest) {
        return FilterTagChildrenVisitor.filterChildren(parent, parent, childTest);
    }

    public static Xml.Tag filterChildren(Xml.Tag parentScope, Xml.Tag parent, Predicate<Content> childTest) {
        return (Xml.Tag)new FilterTagChildrenVisitor(parent, childTest).visitNonNull(parentScope, null);
    }

    public static Xml.Tag filterTagChildren(Xml.Tag parent, Predicate<Xml.Tag> childTest) {
        return FilterTagChildrenVisitor.filterTagChildren(parent, parent, childTest);
    }

    public static Xml.Tag filterTagChildren(Xml.Tag parentScope, Xml.Tag parent, Predicate<Xml.Tag> childTest) {
        return FilterTagChildrenVisitor.filterChildren(parentScope, parent, child -> {
            if (child instanceof Xml.Tag) {
                return childTest.test((Xml.Tag)child);
            }
            return true;
        });
    }

    public FilterTagChildrenVisitor(Xml.Tag scope, Predicate<Content> childTest) {
        this.scope = scope;
        this.childTest = childTest;
    }

    public Xml.Tag getScope() {
        return this.scope;
    }

    public Predicate<Content> getChildTest() {
        return this.childTest;
    }

    @NonNull
    public String toString() {
        return "FilterTagChildrenVisitor(scope=" + this.getScope() + ", childTest=" + this.getChildTest() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterTagChildrenVisitor)) {
            return false;
        }
        FilterTagChildrenVisitor other = (FilterTagChildrenVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Xml.Tag this$scope = this.getScope();
        Xml.Tag other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        Predicate<Content> this$childTest = this.getChildTest();
        Predicate<Content> other$childTest = other.getChildTest();
        return !(this$childTest == null ? other$childTest != null : !this$childTest.equals(other$childTest));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FilterTagChildrenVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Xml.Tag $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        Predicate<Content> $childTest = this.getChildTest();
        result = result * 59 + ($childTest == null ? 43 : $childTest.hashCode());
        return result;
    }
}

