/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.Hashtable;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.ops4j.pax.web.service.jetty.internal.ServerControllerFactoryImpl;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceRegistration registration;
    private ServiceTracker<Handler, Handler> handlerTracker;
    private BundleContext bundleContext;
    private ServiceTracker<Connector, Connector> connectorTracker;
    private ServerControllerFactoryImpl serverControllerFactory;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        for (Bundle b : bundleContext.getBundles()) {
            if (!"org.eclipse.jetty.util".equals(b.getSymbolicName())) continue;
            ShutdownThread.getInstance().setContextClassLoader(((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader());
        }
        this.serverControllerFactory = new ServerControllerFactoryImpl(bundleContext.getBundle());
        this.handlerTracker = new ServiceTracker(bundleContext, Handler.class, (ServiceTrackerCustomizer)new HandlerCustomizer());
        this.handlerTracker.open();
        this.connectorTracker = new ServiceTracker(bundleContext, Connector.class, (ServiceTrackerCustomizer)new ConnectorCustomizer());
        this.connectorTracker.open();
        this.registration = bundleContext.registerService(ServerControllerFactory.class, (Object)this.serverControllerFactory, new Hashtable());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            this.registration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private class ConnectorCustomizer
    implements ServiceTrackerCustomizer<Connector, Connector> {
        private ConnectorCustomizer() {
        }

        public Connector addingService(ServiceReference<Connector> reference) {
            Connector connector = (Connector)Activator.this.bundleContext.getService(reference);
            if (Activator.this.registration != null) {
                Activator.this.registration.unregister();
            }
            Activator.this.serverControllerFactory.addConnector(connector);
            Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            return connector;
        }

        public void modifiedService(ServiceReference<Connector> reference, Connector service) {
        }

        public void removedService(ServiceReference<Connector> reference, Connector connector) {
            Activator.this.bundleContext.ungetService(reference);
            try {
                if (Activator.this.registration != null) {
                    Activator.this.registration.unregister();
                }
                Activator.this.serverControllerFactory.removeConnector(connector);
                Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private class HandlerCustomizer
    implements ServiceTrackerCustomizer<Handler, Handler> {
        private HandlerCustomizer() {
        }

        public Handler addingService(ServiceReference<Handler> reference) {
            Handler handler = (Handler)Activator.this.bundleContext.getService(reference);
            if (Activator.this.registration != null) {
                Activator.this.registration.unregister();
            }
            Activator.this.serverControllerFactory.addHandler(handler);
            Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            return handler;
        }

        public void modifiedService(ServiceReference<Handler> reference, Handler service) {
        }

        public void removedService(ServiceReference<Handler> reference, Handler handler) {
            Activator.this.bundleContext.ungetService(reference);
            try {
                if (Activator.this.registration != null) {
                    Activator.this.registration.unregister();
                }
                Activator.this.serverControllerFactory.removeHandler(handler);
                Activator.this.registration = Activator.this.bundleContext.registerService(ServerControllerFactory.class, (Object)Activator.this.serverControllerFactory, new Hashtable());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }
}

