/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Checksum {
    private static final String HEXES = "0123456789abcdef";
    private static final int BUFFER_SIZE = 1024;
    private static final Logger LOGGER = LoggerFactory.getLogger(Checksum.class);
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA-1";
    private static final String SHA256 = "SHA-256";
    private static final Map<File, FileChecksums> CHECKSUM_CACHE = new ConcurrentHashMap<File, FileChecksums>();

    private Checksum() {
    }

    public static String getChecksum(String algorithm, File file) throws NoSuchAlgorithmException, IOException {
        FileChecksums fileChecksums = CHECKSUM_CACHE.get(file);
        if (fileChecksums == null) {
            try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                MessageDigest md5Digest = Checksum.getMessageDigest(MD5);
                MessageDigest sha1Digest = Checksum.getMessageDigest(SHA1);
                MessageDigest sha256Digest = Checksum.getMessageDigest(SHA256);
                byte[] buffer = new byte[1024];
                int read = stream.read(buffer, 0, 1024);
                while (read > -1) {
                    md5Digest.update(buffer, 0, read);
                    sha1Digest.update(buffer, 0, read);
                    sha256Digest.update(buffer, 0, read);
                    read = stream.read(buffer, 0, 1024);
                }
                fileChecksums = new FileChecksums(Checksum.getHex(md5Digest.digest()), Checksum.getHex(sha1Digest.digest()), Checksum.getHex(sha256Digest.digest()));
                CHECKSUM_CACHE.put(file, fileChecksums);
            }
        }
        switch (algorithm.toUpperCase()) {
            case "MD5": {
                return fileChecksums.md5;
            }
            case "SHA-1": {
                return fileChecksums.sha1;
            }
            case "SHA-256": {
                return fileChecksums.sha256;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static String getMD5Checksum(File file) throws IOException, NoSuchAlgorithmException {
        return Checksum.getChecksum(MD5, file);
    }

    public static String getSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        return Checksum.getChecksum(SHA1, file);
    }

    public static String getSHA256Checksum(File file) throws IOException, NoSuchAlgorithmException {
        return Checksum.getChecksum(SHA256, file);
    }

    public static String getChecksum(String algorithm, byte[] bytes) {
        return Checksum.getHex(Checksum.getMessageDigest(algorithm).digest(bytes));
    }

    public static String getMD5Checksum(String text) {
        return Checksum.getChecksum(MD5, Checksum.stringToBytes(text));
    }

    public static String getSHA1Checksum(String text) {
        return Checksum.getChecksum(SHA1, Checksum.stringToBytes(text));
    }

    public static String getSHA256Checksum(String text) {
        return Checksum.getChecksum(SHA256, Checksum.stringToBytes(text));
    }

    private static byte[] stringToBytes(String text) {
        return text.getBytes(StandardCharsets.UTF_8);
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String msg = String.format("Failed to obtain the %s message digest.", algorithm);
            throw new IllegalStateException(msg, e);
        }
    }

    private static class FileChecksums {
        private final String md5;
        private final String sha1;
        private final String sha256;

        FileChecksums(String md5, String sha1, String sha256) {
            this.md5 = md5;
            this.sha1 = sha1;
            this.sha256 = sha256;
        }
    }
}

