/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.net.URL;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.BearerToken;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.BearerScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HC5CredentialHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HC5CredentialHelper.class);

    private HC5CredentialHelper() {
    }

    public static void configurePreEmptiveBearerAuth(URL theURL, String theToken, CredentialsStore credentialsStore, AuthCache authCache) {
        HttpHost scopeHost = new HttpHost(theURL.getProtocol(), theURL.getHost(), theURL.getPort());
        BearerToken creds = new BearerToken(theToken);
        AuthScope scope = new AuthScope(scopeHost, null, null);
        credentialsStore.setCredentials(scope, (Credentials)creds);
        BearerScheme bearerAuth = new BearerScheme();
        try {
            AuthChallenge preemtiveAuthDummyChallenge = new AuthChallenge(ChallengeType.TARGET, scopeHost.getSchemeName(), new NameValuePair[0]);
            HttpClientContext preEmptiveAuthDummyContext = new HttpClientContext();
            bearerAuth.processChallenge(preemtiveAuthDummyChallenge, (HttpContext)preEmptiveAuthDummyContext);
            if (!bearerAuth.isResponseReady(scopeHost, (CredentialsProvider)credentialsStore, (HttpContext)preEmptiveAuthDummyContext)) {
                LOGGER.warn("Bearer Credentials failed to be be pre-empted for {}", (Object)theURL);
            }
            authCache.put(scopeHost, (AuthScheme)bearerAuth);
        }
        catch (AuthenticationException | MalformedChallengeException e) {
            LOGGER.warn("Bearer Credentials failed to be be pre-empted for {}", (Object)theURL, (Object)e);
        }
    }

    public static void configurePreEmptiveBasicAuth(URL theURL, String theUser, String thePass, CredentialsStore credentialsStore, AuthCache authCache) {
        HttpHost scopeHost = new HttpHost(theURL.getProtocol(), theURL.getHost(), theURL.getPort());
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(theUser, thePass.toCharArray());
        AuthScope scope = new AuthScope(scopeHost, null, null);
        credentialsStore.setCredentials(scope, (Credentials)creds);
        BasicScheme basicAuth = new BasicScheme();
        basicAuth.initPreemptive((Credentials)creds);
        authCache.put(scopeHost, (AuthScheme)basicAuth);
    }
}

