/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;

public class SonarQubeTask
extends ConventionTask {
    private static final Logger LOGGER = Logging.getLogger(SonarQubeTask.class);
    private static final LogOutput LOG_OUTPUT = new DefaultLogOutput();
    private Map<String, String> sonarProperties;

    @TaskAction
    public void run() {
        Map<String, String> properties = this.getProperties();
        if (properties.isEmpty()) {
            LOGGER.warn("Skipping SonarQube analysis: no properties configured, was it skipped in all projects?");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            properties.put("sonar.verbose", "true");
        }
        if (SonarQubeTask.isSkippedWithProperty(properties)) {
            return;
        }
        EmbeddedScanner scanner = EmbeddedScanner.create((String)"ScannerGradle", (String)(this.getPluginVersion() + "/" + this.getProject().getGradle().getGradleVersion()), (LogOutput)LOG_OUTPUT).addGlobalProperties(properties);
        scanner.start();
        scanner.execute(new HashMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPluginVersion() {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/version.txt");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = reader.readLine();
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to find the version of the plugin", (Throwable)e);
            return "";
        }
    }

    private static boolean isSkippedWithProperty(Map<String, String> properties) {
        if ("true".equalsIgnoreCase(properties.getOrDefault("sonar.scanner.skip", "false"))) {
            LOGGER.warn("SonarQube Scanner analysis skipped");
            return true;
        }
        return false;
    }

    @Input
    public Map<String, String> getProperties() {
        if (this.sonarProperties == null) {
            this.sonarProperties = new LinkedHashMap<String, String>();
        }
        return this.sonarProperties;
    }

    private static class DefaultLogOutput
    implements LogOutput {
        private DefaultLogOutput() {
        }

        public void log(String formattedMessage, LogOutput.Level level) {
            switch (level) {
                case TRACE: {
                    LOGGER.trace(formattedMessage);
                    return;
                }
                case DEBUG: {
                    LOGGER.debug(formattedMessage);
                    return;
                }
                case INFO: {
                    LOGGER.info(formattedMessage);
                    return;
                }
                case WARN: {
                    LOGGER.warn(formattedMessage);
                    return;
                }
                case ERROR: {
                    LOGGER.error(formattedMessage);
                    return;
                }
            }
            throw new IllegalArgumentException(level.name());
        }
    }
}

