/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.util.Objects;
import java.util.Optional;

class JavaCompilerConfiguration {
    private String release;
    private String target;
    private String source;
    private String jdkHome;
    private boolean enablePreview;
    private final String taskName;

    JavaCompilerConfiguration(String taskName) {
        this.taskName = taskName;
    }

    public Optional<String> getRelease() {
        return Optional.ofNullable(this.release);
    }

    public Optional<String> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Optional<String> getJdkHome() {
        return Optional.ofNullable(this.jdkHome);
    }

    public boolean getEnablePreview() {
        return this.enablePreview;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public static boolean same(JavaCompilerConfiguration one, JavaCompilerConfiguration two) {
        return Objects.equals(one.jdkHome, two.jdkHome) && Objects.equals(one.release, two.release) && Objects.equals(one.source, two.source) && Objects.equals(one.target, two.target) && one.enablePreview == two.enablePreview;
    }

    public void setJdkHome(String jdkHome) {
        this.jdkHome = jdkHome;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setEnablePreview(boolean enablePreview) {
        this.enablePreview = enablePreview;
    }
}

