/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.util.GradleVersion;
import org.sonarqube.gradle.ActionBroadcast;
import org.sonarqube.gradle.AndroidUtils;
import org.sonarqube.gradle.JavaCompilerUtils;
import org.sonarqube.gradle.SonarProperties;
import org.sonarqube.gradle.SonarQubePlugin;
import org.sonarqube.gradle.SonarUtils;
import org.sonarsource.scanner.api.Utils;

public class SonarPropertyComputer {
    private static final Logger LOGGER = Logging.getLogger(SonarPropertyComputer.class);
    private static final Pattern TEST_RESULT_FILE_PATTERN = Pattern.compile("TESTS?-.*\\.xml");
    static final String SONAR_SOURCES_PROP = "sonar.sources";
    static final String SONAR_TESTS_PROP = "sonar.tests";
    private static final String MAIN_SOURCE_SET_SUFFIX = "main";
    private static final String TEST_SOURCE_SET_SUFFIX = "test";
    private final Map<String, ActionBroadcast<SonarProperties>> actionBroadcastMap;
    private final Project targetProject;

    public SonarPropertyComputer(Map<String, ActionBroadcast<SonarProperties>> actionBroadcastMap, Project targetProject) {
        this.actionBroadcastMap = actionBroadcastMap;
        this.targetProject = targetProject;
    }

    public Map<String, Object> computeSonarProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.computeSonarProperties(this.targetProject, properties, "");
        if (properties.containsKey("sonar.projectBaseDir")) {
            properties.put("sonar.projectBaseDir", SonarUtils.findProjectBaseDir(properties));
        }
        if (SonarQubePlugin.notSkipped(this.targetProject)) {
            properties.put("sonar.kotlin.gradleProjectRoot", this.targetProject.getRootProject().getProjectDir().getAbsolutePath());
        }
        return properties;
    }

    private void computeSonarProperties(Project project, Map<String, Object> properties, String prefix) {
        ActionBroadcast<SonarProperties> actionBroadcast;
        if (!SonarQubePlugin.notSkipped(project)) {
            return;
        }
        LinkedHashMap<String, Object> rawProperties = new LinkedHashMap<String, Object>();
        this.addGradleDefaults(project, rawProperties);
        if (SonarUtils.isAndroidProject(project)) {
            AndroidUtils.configureForAndroid(project, SonarQubePlugin.getConfiguredAndroidVariant(project), rawProperties);
        }
        if ((actionBroadcast = this.actionBroadcastMap.get(project.getPath())) != null) {
            SonarPropertyComputer.evaluateSonarPropertiesBlocks(actionBroadcast, rawProperties);
        }
        if (project.equals(this.targetProject)) {
            SonarPropertyComputer.addEnvironmentProperties(rawProperties);
            SonarPropertyComputer.addSystemProperties(rawProperties);
            SonarPropertyComputer.addKotlinBuildScriptsToSources(project, rawProperties);
        }
        rawProperties.putIfAbsent(SONAR_SOURCES_PROP, "");
        if (project.equals(this.targetProject)) {
            rawProperties.putIfAbsent("sonar.projectKey", this.computeProjectKey());
        } else {
            String projectKey = (String)properties.get("sonar.projectKey");
            rawProperties.putIfAbsent("sonar.moduleKey", projectKey + project.getPath());
        }
        SonarPropertyComputer.convertProperties(rawProperties, prefix, properties);
        List enabledChildProjects = project.getChildProjects().values().stream().filter(SonarQubePlugin::notSkipped).collect(Collectors.toList());
        List<Project> skippedChildProjects = project.getChildProjects().values().stream().filter(p -> !SonarQubePlugin.notSkipped(p)).collect(Collectors.toList());
        if (!skippedChildProjects.isEmpty()) {
            LOGGER.debug("Skipping collecting Sonar properties on: " + Arrays.toString(skippedChildProjects.toArray(new Project[0])));
        }
        if (enabledChildProjects.isEmpty()) {
            return;
        }
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (Project childProject : enabledChildProjects) {
            String moduleId = childProject.getPath();
            moduleIds.add(moduleId);
            String modulePrefix = prefix.length() > 0 ? prefix + "." + moduleId : moduleId;
            this.computeSonarProperties(childProject, properties, modulePrefix);
        }
        properties.put(SonarPropertyComputer.convertKey("sonar.modules", prefix), String.join((CharSequence)",", moduleIds));
    }

    private static void evaluateSonarPropertiesBlocks(ActionBroadcast<? super SonarProperties> propertiesActions, Map<String, Object> properties) {
        SonarProperties sqProperties = new SonarProperties(properties);
        propertiesActions.execute(sqProperties);
    }

    private static void convertProperties(Map<String, Object> rawProperties, String projectPrefix, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String value = SonarPropertyComputer.convertValue(entry.getValue(), false);
            if (value == null) continue;
            properties.put(SonarPropertyComputer.convertKey(entry.getKey(), projectPrefix), value);
        }
    }

    private static String convertKey(String key, String projectPrefix) {
        return projectPrefix.isEmpty() ? key : projectPrefix + "." + key;
    }

    private static String convertValue(@Nullable Object value, boolean escapeFilePath) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            String joined = StreamSupport.stream(((Iterable)value).spliterator(), false).map(v -> SonarPropertyComputer.convertValue(v, true)).filter(Objects::nonNull).collect(Collectors.joining(","));
            return joined.isEmpty() ? null : joined;
        }
        if (value instanceof File && escapeFilePath) {
            return SonarPropertyComputer.getEscapedFilePath((File)value);
        }
        return value.toString();
    }

    private static String getEscapedFilePath(File file) {
        String filePath = file.toString();
        if (filePath.contains(",")) {
            return "\"" + filePath.replace("\"", "\\\"") + "\"";
        }
        return filePath;
    }

    private static void configureSourceEncoding(Project project, Map<String, Object> properties) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            String encoding = compile.getOptions().getEncoding();
            if (encoding != null) {
                properties.put("sonar.sourceEncoding", encoding);
            }
        });
    }

    private static void addEnvironmentProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> e : Utils.loadEnvironmentProperties(System.getenv()).entrySet()) {
            properties.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    private static void addSystemProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("sonar")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private static void configureForJava(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(JavaBasePlugin.class, javaBasePlugin -> SonarPropertyComputer.populateJdkProperties(project, properties));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> SonarPropertyComputer.configureSourceDirsAndJavaClasspath(project, properties, false));
    }

    private static void configureForKotlin(Project project, Map<String, Object> properties, Object kotlinProjectExtension) {
        Collection<File> testDirectories;
        Collection<File> sourceDirectories = SonarPropertyComputer.getKotlinSourceFiles(kotlinProjectExtension, MAIN_SOURCE_SET_SUFFIX);
        if (sourceDirectories != null) {
            SonarUtils.appendSourcesProp(properties, sourceDirectories, false);
        }
        if ((testDirectories = SonarPropertyComputer.getKotlinSourceFiles(kotlinProjectExtension, TEST_SOURCE_SET_SUFFIX)) != null) {
            SonarUtils.appendSourcesProp(properties, testDirectories, true);
        }
        if (sourceDirectories != null || testDirectories != null) {
            SonarPropertyComputer.configureSourceEncoding(project, properties);
            SonarPropertyComputer.extractTestProperties(project, properties, false);
        }
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> SonarPropertyComputer.configureJavaClasspath(project, properties, false));
    }

    private static void configureForGroovy(Project project, Map<String, Object> properties) {
        project.getPlugins().withType(GroovyBasePlugin.class, groovyBasePlugin -> SonarPropertyComputer.populateJdkProperties(project, properties));
        project.getPlugins().withType(GroovyPlugin.class, groovyPlugin -> SonarPropertyComputer.configureSourceDirsAndJavaClasspath(project, properties, true));
    }

    private static void populateJdkProperties(Project project, Map<String, Object> properties) {
        JavaCompilerUtils.extractJavaCompilerConfigurationFromCompileTasks(project).ifPresent(config -> SonarUtils.populateJdkProperties(properties, config));
    }

    private static void extractTestProperties(Project project, Map<String, Object> properties, boolean addForGroovy) {
        Task testTask = (Task)project.getTasks().findByName(TEST_SOURCE_SET_SUFFIX);
        if (testTask instanceof Test) {
            SonarPropertyComputer.configureTestReports((Test)testTask, properties);
            SonarPropertyComputer.configureJaCoCoCoverageReport((Test)testTask, project, properties, addForGroovy);
        }
    }

    private static void configureJaCoCoCoverageReport(Test testTask, Project project, Map<String, Object> properties, boolean addForGroovy) {
        project.getTasks().withType(JacocoReport.class, jacocoReportTask -> {
            SingleFileReport xmlReport = jacocoReportTask.getReports().getXml();
            File reportDestination = SonarPropertyComputer.getDestination((Report)xmlReport);
            if (SonarPropertyComputer.isReportEnabled((Report)xmlReport) && reportDestination != null && reportDestination.exists()) {
                SonarUtils.appendProp(properties, "sonar.coverage.jacoco.xmlReportPaths", reportDestination);
            } else {
                LOGGER.info("JaCoCo report task detected, but XML report is not enabled or it was not produced. Coverage for this task will not be reported.");
            }
        });
        project.getPlugins().withType(JacocoPlugin.class, jacocoPlugin -> {
            JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)testTask.getExtensions().getByType(JacocoTaskExtension.class);
            File destinationFile = jacocoTaskExtension.getDestinationFile();
            if (destinationFile != null && destinationFile.exists()) {
                properties.put("sonar.jacoco.reportPath", destinationFile);
                SonarUtils.appendProp(properties, "sonar.jacoco.reportPaths", destinationFile);
                if (addForGroovy) {
                    properties.put("sonar.groovy.jacoco.reportPath", destinationFile);
                }
            }
        });
    }

    private static void configureTestReports(Test testTask, Map<String, Object> properties) {
        File testResultsDir = SonarPropertyComputer.getDestination((Report)testTask.getReports().getJunitXml());
        if (testResultsDir != null && testResultsDir.isDirectory() && Arrays.stream(testResultsDir.list()).anyMatch(file -> TEST_RESULT_FILE_PATTERN.matcher((CharSequence)file).matches())) {
            SonarUtils.appendProp(properties, "sonar.junit.reportPaths", testResultsDir);
            SonarUtils.appendProp(properties, "sonar.junit.reportsPath", testResultsDir);
            SonarUtils.appendProp(properties, "sonar.surefire.reportsPath", testResultsDir);
        }
    }

    private static void configureSourceDirsAndJavaClasspath(Project project, Map<String, Object> properties, boolean addForGroovy) {
        SourceSet test;
        Collection<File> testDirectories;
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaPluginConvention.getSourceSets().getAt(MAIN_SOURCE_SET_SUFFIX);
        Collection<File> sourceDirectories = SonarPropertyComputer.getJavaSourceFiles(main);
        if (sourceDirectories != null) {
            SonarUtils.appendSourcesProp(properties, sourceDirectories, false);
        }
        if ((testDirectories = SonarPropertyComputer.getJavaSourceFiles(test = (SourceSet)javaPluginConvention.getSourceSets().getAt(TEST_SOURCE_SET_SUFFIX))) != null) {
            SonarUtils.appendSourcesProp(properties, testDirectories, true);
        }
        if (sourceDirectories != null || testDirectories != null) {
            SonarPropertyComputer.configureSourceEncoding(project, properties);
            SonarPropertyComputer.extractTestProperties(project, properties, addForGroovy);
        }
        SonarPropertyComputer.configureJavaClasspath(project, properties, addForGroovy);
    }

    private static void configureJavaClasspath(Project project, Map<String, Object> properties, boolean addForGroovy) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaPluginConvention.getSourceSets().getAt(MAIN_SOURCE_SET_SUFFIX);
        Collection<File> mainClassDirs = SonarPropertyComputer.getJavaOutputDirs(main);
        Collection<File> mainLibraries = SonarPropertyComputer.getJavaLibraries(main);
        SonarUtils.setMainClasspathProps(properties, mainClassDirs, mainLibraries, addForGroovy);
        SourceSet test = (SourceSet)javaPluginConvention.getSourceSets().getAt(TEST_SOURCE_SET_SUFFIX);
        Collection<File> testClassDirs = SonarPropertyComputer.getJavaOutputDirs(test);
        Collection<File> testLibraries = SonarPropertyComputer.getJavaLibraries(test);
        SonarUtils.setTestClasspathProps(properties, testClassDirs, testLibraries);
    }

    @Nullable
    private static Collection<File> getJavaSourceFiles(SourceSet sourceSet) {
        List sourceDirectories = sourceSet.getAllJava().getSrcDirs().stream().filter(File::exists).collect(Collectors.toList());
        return SonarUtils.nonEmptyOrNull(sourceDirectories);
    }

    private static Collection<File> getJavaOutputDirs(SourceSet sourceSet) {
        return SonarUtils.exists(sourceSet.getOutput().getClassesDirs().getFiles());
    }

    @Nullable
    private static Collection<File> getKotlinSourceFiles(Object extension, String sourceSetNameSuffix) {
        try {
            Method getSourceSetsMethod = extension.getClass().getMethod("getSourceSets", new Class[0]);
            NamedDomainObjectContainer sourceSets = (NamedDomainObjectContainer)getSourceSetsMethod.invoke(extension, new Object[0]);
            Collection sourceFiles = sourceSets.stream().map(x$0 -> InternalKotlinSourceSet.of(x$0)).filter(s -> s.name.toLowerCase(Locale.ROOT).endsWith(sourceSetNameSuffix)).flatMap(s -> s.srcDirs.stream()).filter(File::exists).collect(Collectors.toList());
            return SonarUtils.nonEmptyOrNull(sourceFiles);
        }
        catch (Exception e) {
            LOGGER.warn("Sonar plugin wasn't able to locate Kotlin source sets. Continue without sources. Root cause: " + e.getMessage());
            return null;
        }
    }

    private static Collection<File> getJavaLibraries(SourceSet main) {
        File fxRuntimeJar;
        List<File> libraries = SonarUtils.exists(main.getCompileClasspath().getFiles());
        File runtimeJar = SonarPropertyComputer.getRuntimeJar();
        if (runtimeJar != null) {
            libraries.add(runtimeJar);
        }
        if ((fxRuntimeJar = SonarPropertyComputer.getFxRuntimeJar()) != null) {
            libraries.add(fxRuntimeJar);
        }
        return libraries;
    }

    private static File getRuntimeJar() {
        try {
            File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            File runtimeJar = new File(javaBase, "lib/rt.jar");
            if (runtimeJar.exists()) {
                return runtimeJar;
            }
            runtimeJar = new File(javaBase, "jre/lib/rt.jar");
            return runtimeJar.exists() ? runtimeJar : null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static File getFxRuntimeJar() {
        try {
            File javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            File runtimeJar = new File(javaBase, "lib/ext/jfxrt.jar");
            if (runtimeJar.exists()) {
                return runtimeJar;
            }
            runtimeJar = new File(javaBase, "jre/lib/ext/jfxrt.jar");
            return runtimeJar.exists() ? runtimeJar : null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addGradleDefaults(Project project, Map<String, Object> properties) {
        Object kotlinExtension;
        properties.put("sonar.projectName", project.getName());
        properties.put("sonar.projectDescription", project.getDescription());
        properties.put("sonar.projectVersion", project.getVersion());
        properties.put("sonar.projectBaseDir", project.getProjectDir());
        if (project.equals(this.targetProject)) {
            properties.put("sonar.working.directory", new File(project.getBuildDir(), "sonar"));
        }
        if ((kotlinExtension = project.getExtensions().findByName("kotlin")) != null && kotlinExtension.getClass().getName().startsWith("org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension")) {
            SonarPropertyComputer.configureForKotlin(project, properties, kotlinExtension);
        } else if (project.getPlugins().hasPlugin(GroovyBasePlugin.class)) {
            SonarPropertyComputer.configureForGroovy(project, properties);
        } else {
            SonarPropertyComputer.configureForJava(project, properties);
        }
    }

    private static void addKotlinBuildScriptsToSources(Project project, Map<String, Object> properties) {
        List<File> buildScripts = project.getAllprojects().stream().filter(SonarQubePlugin::notSkipped).map(Project::getBuildFile).filter(file -> file.getAbsolutePath().endsWith("kts")).collect(Collectors.toList());
        File settingsFile = Path.of(project.getProjectDir().getAbsolutePath(), "settings.gradle.kts").toFile();
        if (settingsFile.exists()) {
            buildScripts.add(settingsFile);
        }
        if (!buildScripts.isEmpty()) {
            SonarUtils.appendSourcesProp(properties, buildScripts, false);
        }
    }

    private String computeProjectKey() {
        String rootKey;
        Project rootProject = this.targetProject.getRootProject();
        String rootProjectName = rootProject.getName();
        String rootGroup = rootProject.getGroup().toString();
        String string = rootKey = rootGroup.isEmpty() ? rootProjectName : rootGroup + ":" + rootProjectName;
        if (this.targetProject == rootProject) {
            return rootKey;
        }
        return rootKey + this.targetProject.getPath();
    }

    private static boolean isReportEnabled(Report report) {
        try {
            if (GradleVersion.version((String)"7.0").compareTo(GradleVersion.current()) <= 0) {
                return (Boolean)report.getRequired().getOrElse((Object)false);
            }
            Method isEnabledGradle5 = report.getClass().getMethod("isEnabled", new Class[0]);
            return (Boolean)isEnabledGradle5.invoke((Object)report, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to check if report is enabled.", e);
        }
    }

    @CheckForNull
    private static File getDestination(Report report) {
        try {
            if (GradleVersion.version((String)"7.0").compareTo(GradleVersion.current()) <= 0) {
                return SonarPropertyComputer.getDestinationNewApi(report);
            }
            return SonarPropertyComputer.getDestinationOldApi(report);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to check the destination of the report.", e);
        }
    }

    private static File getDestinationNewApi(Report report) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Provider provider;
        if (GradleVersion.version((String)"8.0").compareTo(GradleVersion.current()) <= 0) {
            Method getOutputLocationGradle8 = report.getClass().getMethod("getOutputLocation", new Class[0]);
            provider = (Property)getOutputLocationGradle8.invoke((Object)report, new Object[0]);
        } else {
            provider = report.getOutputLocation();
        }
        FileSystemLocation location = (FileSystemLocation)provider.getOrNull();
        if (location != null) {
            return location.getAsFile();
        }
        return null;
    }

    private static File getDestinationOldApi(Report report) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method getDestinationGradle5 = report.getClass().getMethod("getDestination", new Class[0]);
        return (File)getDestinationGradle5.invoke((Object)report, new Object[0]);
    }

    private static class InternalKotlinSourceSet {
        private String name;
        private Collection<File> srcDirs;

        private InternalKotlinSourceSet() {
        }

        private static InternalKotlinSourceSet of(Object rawSourceSet) {
            InternalKotlinSourceSet internalKotlinSourceSet = new InternalKotlinSourceSet();
            try {
                Method getName = rawSourceSet.getClass().getMethod("getName", new Class[0]);
                internalKotlinSourceSet.name = (String)getName.invoke(rawSourceSet, new Object[0]);
                Method getKotlin = rawSourceSet.getClass().getMethod("getKotlin", new Class[0]);
                Object kotlin = getKotlin.invoke(rawSourceSet, new Object[0]);
                Method getSrcDirs = kotlin.getClass().getMethod("getSrcDirs", new Class[0]);
                internalKotlinSourceSet.srcDirs = (Collection)getSrcDirs.invoke(kotlin, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Sonar plugin wasn't able to locate source set. Root cause: " + e.getMessage());
            }
            return internalKotlinSourceSet;
        }
    }
}

