/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;

public class SonarTask
extends ConventionTask {
    private static final Logger LOGGER = Logging.getLogger(SonarTask.class);
    private LogOutput logOutput = new DefaultLogOutput();
    private Provider<Map<String, String>> properties;

    @TaskAction
    public void run() {
        Map<String, String> mapProperties;
        if ("sonarqube".equals(this.getName())) {
            LOGGER.warn("Task 'sonarqube' is deprecated. Use 'sonar' instead.");
        }
        if ((mapProperties = (HashMap<String, String>)this.getProperties().get()).isEmpty()) {
            LOGGER.warn("Skipping Sonar analysis: no properties configured, was it skipped in all projects?");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            mapProperties = new HashMap<String, String>(mapProperties);
            mapProperties.put("sonar.verbose", "true");
            mapProperties = Collections.unmodifiableMap(mapProperties);
        }
        if (SonarTask.isSkippedWithProperty(mapProperties)) {
            return;
        }
        EmbeddedScanner scanner = EmbeddedScanner.create((String)"ScannerGradle", (String)(this.getPluginVersion() + "/" + GradleVersion.current()), (LogOutput)this.getLogOutput()).addGlobalProperties(mapProperties);
        scanner.start();
        scanner.execute(new HashMap());
    }

    private String getPluginVersion() {
        String string;
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/version.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to find the version of the plugin", (Throwable)e);
                return "";
            }
        }
        reader.close();
        return string;
    }

    private static boolean isSkippedWithProperty(Map<String, String> properties) {
        if ("true".equalsIgnoreCase(properties.getOrDefault("sonar.scanner.skip", "false"))) {
            LOGGER.warn("Sonar Scanner analysis skipped");
            return true;
        }
        return false;
    }

    @Input
    public Provider<Map<String, String>> getProperties() {
        return this.properties;
    }

    void setProperties(Provider<Map<String, String>> properties) {
        this.properties = properties;
    }

    public void useLoggerLevel(LogLevel logLevel) {
        LogOutput.Level internalLevel = LogOutput.Level.valueOf((String)logLevel.name());
        this.logOutput = new LifecycleLogOutput(internalLevel);
    }

    @Internal
    public LogOutput getLogOutput() {
        return this.logOutput;
    }

    public void setLogOutput(LogOutput logOutput) {
        this.logOutput = logOutput;
    }

    private static class LifecycleLogOutput
    implements LogOutput {
        private final LogOutput.Level logLevel;

        public LifecycleLogOutput(LogOutput.Level logLevel) {
            this.logLevel = logLevel;
        }

        public void log(String formattedMessage, LogOutput.Level level) {
            if (level.ordinal() <= this.logLevel.ordinal()) {
                LOGGER.lifecycle(formattedMessage);
            }
        }
    }

    private static class DefaultLogOutput
    implements LogOutput {
        private DefaultLogOutput() {
        }

        public void log(String formattedMessage, LogOutput.Level level) {
            switch (level) {
                case TRACE: {
                    LOGGER.trace(formattedMessage);
                    return;
                }
                case DEBUG: {
                    LOGGER.debug(formattedMessage);
                    return;
                }
                case INFO: {
                    LOGGER.info(formattedMessage);
                    return;
                }
                case WARN: {
                    LOGGER.warn(formattedMessage);
                    return;
                }
                case ERROR: {
                    LOGGER.error(formattedMessage);
                    return;
                }
            }
            throw new IllegalArgumentException(level.name());
        }
    }
}

