/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.jdbc.AbstractDataSourceInitializer;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class BatchDataSourceInitializer
extends AbstractDataSourceInitializer {
    private final BatchProperties.Jdbc jdbcProperties;

    public BatchDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader, BatchProperties properties) {
        super(dataSource, resourceLoader);
        Assert.notNull((Object)properties, (String)"BatchProperties must not be null");
        this.jdbcProperties = properties.getJdbc();
    }

    protected DataSourceInitializationMode getMode() {
        return this.jdbcProperties.getInitializeSchema();
    }

    protected String getSchemaLocation() {
        return this.jdbcProperties.getSchema();
    }

    protected String getDatabaseName() {
        String databaseName = super.getDatabaseName();
        if ("oracle".equals(databaseName)) {
            return "oracle10g";
        }
        if ("mariadb".equals(databaseName)) {
            return "mysql";
        }
        return databaseName;
    }
}

