/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.util.stream.Collectors;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.boot.autoconfigure.amqp.PropertiesRabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.util.Assert;

public abstract class AbstractConnectionFactoryConfigurer<T extends AbstractConnectionFactory> {
    private final RabbitProperties rabbitProperties;
    private ConnectionNameStrategy connectionNameStrategy;
    private final RabbitConnectionDetails connectionDetails;

    protected AbstractConnectionFactoryConfigurer(RabbitProperties properties) {
        this(properties, new PropertiesRabbitConnectionDetails(properties));
    }

    protected AbstractConnectionFactoryConfigurer(RabbitProperties properties, RabbitConnectionDetails connectionDetails) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        Assert.notNull((Object)connectionDetails, (String)"'connectionDetails' must not be null");
        this.rabbitProperties = properties;
        this.connectionDetails = connectionDetails;
    }

    protected final ConnectionNameStrategy getConnectionNameStrategy() {
        return this.connectionNameStrategy;
    }

    public final void setConnectionNameStrategy(ConnectionNameStrategy connectionNameStrategy) {
        this.connectionNameStrategy = connectionNameStrategy;
    }

    public final void configure(T connectionFactory) {
        Assert.notNull(connectionFactory, (String)"'connectionFactory' must not be null");
        PropertyMapper map = PropertyMapper.get();
        String addresses = this.connectionDetails.getAddresses().stream().map(address -> address.host() + ":" + address.port()).collect(Collectors.joining(","));
        map.from((Object)addresses).to(arg_0 -> connectionFactory.setAddresses(arg_0));
        map.from(this.rabbitProperties::getAddressShuffleMode).whenNonNull().to(arg_0 -> connectionFactory.setAddressShuffleMode(arg_0));
        map.from((Object)this.connectionNameStrategy).whenNonNull().to(arg_0 -> connectionFactory.setConnectionNameStrategy(arg_0));
        this.configure(connectionFactory, this.rabbitProperties);
    }

    protected abstract void configure(T var1, RabbitProperties var2);
}

