/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;

public class WebResourcesRuntimeHints
implements RuntimeHintsRegistrar {
    private static final List<String> DEFAULT_LOCATIONS = List.of("META-INF/resources/", "resources/", "static/", "public/");

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ClassLoader classLoaderToUse = classLoader != null ? classLoader : this.getClass().getClassLoader();
        String[] locations = (String[])DEFAULT_LOCATIONS.stream().filter(candidate -> classLoaderToUse.getResource((String)candidate) != null).map(location -> location + "**").toArray(String[]::new);
        if (locations.length > 0) {
            hints.resources().registerPattern(hint -> hint.includes(locations));
        }
    }
}

