/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;

class KotlinPluginAction
implements PluginApplicationAction {
    KotlinPluginAction() {
    }

    public void execute(Project project) {
        ExtraPropertiesExtension extraProperties = project.getExtensions().getExtraProperties();
        if (!extraProperties.has("kotlin.version")) {
            String kotlinVersion = this.getKotlinVersion(project);
            extraProperties.set("kotlin.version", (Object)kotlinVersion);
        }
        this.enableJavaParametersOption(project);
    }

    private String getKotlinVersion(Project project) {
        return KotlinPluginWrapperKt.getKotlinPluginVersion((Project)project);
    }

    private void enableJavaParametersOption(Project project) {
        project.getTasks().withType(KotlinCompile.class, compile -> compile.getKotlinOptions().setJavaParameters(true));
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return KotlinPluginWrapper.class;
    }
}

