/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson2;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.jackson2.JsonMixin;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Deprecated(since="4.0.0", forRemoval=true)
public final class JsonMixinModuleEntries {
    private final Map<Object, Object> entries;

    private JsonMixinModuleEntries(Builder builder) {
        this.entries = new LinkedHashMap<Object, Object>(builder.entries);
    }

    public static JsonMixinModuleEntries create(Consumer<Builder> mixins) {
        Builder builder = new Builder();
        mixins.accept(builder);
        return builder.build();
    }

    public static JsonMixinModuleEntries scan(ApplicationContext context, Collection<String> basePackages) {
        return JsonMixinModuleEntries.create(builder -> {
            if (ObjectUtils.isEmpty((Object)basePackages)) {
                return;
            }
            JsonMixinComponentScanner scanner = new JsonMixinComponentScanner();
            scanner.setEnvironment(context.getEnvironment());
            scanner.setResourceLoader((ResourceLoader)context);
            for (String basePackage : basePackages) {
                if (!StringUtils.hasText((String)basePackage)) continue;
                for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
                    String beanClassName = candidate.getBeanClassName();
                    Assert.state((beanClassName != null ? 1 : 0) != 0, (String)"'beanClassName' must not be null");
                    Class mixinClass = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)context.getClassLoader());
                    JsonMixinModuleEntries.registerMixinClass(builder, mixinClass);
                }
            }
        });
    }

    private static void registerMixinClass(Builder builder, Class<?> mixinClass) {
        MergedAnnotation annotation = MergedAnnotations.from(mixinClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(JsonMixin.class);
        Object[] types = annotation.getClassArray("type");
        Assert.state((!ObjectUtils.isEmpty((Object[])types) ? 1 : 0) != 0, () -> "@JsonMixin annotation on class '" + mixinClass.getName() + "' does not specify any types");
        for (Object type : types) {
            builder.and((Class<?>)type, mixinClass);
        }
    }

    public void doWithEntry(@Nullable ClassLoader classLoader, BiConsumer<Class<?>, Class<?>> action) {
        this.entries.forEach((type, mixin) -> action.accept(this.resolveClassNameIfNecessary(type, classLoader), this.resolveClassNameIfNecessary(mixin, classLoader)));
    }

    private Class<?> resolveClassNameIfNecessary(Object nameOrType, @Nullable ClassLoader classLoader) {
        Class type;
        return nameOrType instanceof Class ? (type = (Class)nameOrType) : ClassUtils.resolveClassName((String)((String)nameOrType), (ClassLoader)classLoader);
    }

    public static class Builder {
        private final Map<Object, Object> entries = new LinkedHashMap<Object, Object>();

        Builder() {
        }

        public Builder and(String typeClassName, String mixinClassName) {
            this.entries.put(typeClassName, mixinClassName);
            return this;
        }

        public Builder and(Class<?> type, Class<?> mixinClass) {
            this.entries.put(type, mixinClass);
            return this;
        }

        JsonMixinModuleEntries build() {
            return new JsonMixinModuleEntries(this);
        }
    }

    static class JsonMixinComponentScanner
    extends ClassPathScanningCandidateComponentProvider {
        JsonMixinComponentScanner() {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(JsonMixin.class));
        }

        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }
}

