/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.boot.test.context.ImportsContextCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ImportsContextCustomizerFactory
implements ContextCustomizerFactory {
    ImportsContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        if (MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Import.class)) {
            this.assertHasNoBeanMethods(testClass);
            return new ImportsContextCustomizer(testClass);
        }
        return null;
    }

    private void assertHasNoBeanMethods(Class<?> testClass) {
        ReflectionUtils.doWithMethods(testClass, this::assertHasNoBeanMethods);
    }

    private void assertHasNoBeanMethods(Method method) {
        Assert.state((!MergedAnnotations.from((AnnotatedElement)method).isPresent(Bean.class) ? 1 : 0) != 0, (String)"Test classes cannot include @Bean methods");
    }
}

