/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery.reactive;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class ConsulReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger logger = LoggerFactory.getLogger(ConsulReactiveDiscoveryClient.class);
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;
    private final ConsulDiscoveryClient blockingClient;

    public ConsulReactiveDiscoveryClient(ConsulClient client, ConsulDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
        this.blockingClient = new ConsulDiscoveryClient(client, properties);
    }

    public String description() {
        return "Spring Cloud Consul Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Flux.defer(() -> {
            List<ServiceInstance> instances = this.blockingClient.getInstances(serviceId);
            return Flux.fromIterable(instances);
        }).onErrorResume(exception -> {
            logger.error("Error getting instances from Consul.", exception);
            return Flux.empty();
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> {
            List<String> services = this.blockingClient.getServices();
            return services == null ? Flux.empty() : Flux.fromIterable(services);
        }).onErrorResume(exception -> {
            logger.error("Error getting services from Consul.", exception);
            return Flux.empty();
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

