/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierStreamMessageBuilder;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.ChannelBindingServiceProperties;
import org.springframework.cloud.stream.test.binder.MessageCollector;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class StreamStubMessages
implements MessageVerifier<Message<?>> {
    private static final Logger log = LoggerFactory.getLogger(StreamStubMessages.class);
    private final ApplicationContext context;
    private final MessageCollector messageCollector;
    private final ContractVerifierStreamMessageBuilder builder = new ContractVerifierStreamMessageBuilder();

    @Autowired
    public StreamStubMessages(ApplicationContext context) {
        this.context = context;
        this.messageCollector = (MessageCollector)context.getBean(MessageCollector.class);
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination) {
        this.send(this.builder.create(payload, headers), destination);
    }

    @Override
    public void send(Message<?> message, String destination) {
        try {
            MessageChannel messageChannel = (MessageChannel)this.context.getBean(this.resolvedDestination(destination), MessageChannel.class);
            messageChannel.send(message);
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to send a message [" + message + "] to a channel with name [" + destination + "]", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Message<?> receive(String destination, long timeout, TimeUnit timeUnit) {
        try {
            MessageChannel messageChannel = (MessageChannel)this.context.getBean(this.resolvedDestination(destination), MessageChannel.class);
            return (Message)this.messageCollector.forChannel(messageChannel).poll(timeout, timeUnit);
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to read a message from  a channel with name [" + destination + "]", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private String resolvedDestination(String destination) {
        try {
            ChannelBindingServiceProperties channelBindingServiceProperties = (ChannelBindingServiceProperties)this.context.getBean(ChannelBindingServiceProperties.class);
            for (Map.Entry entry : channelBindingServiceProperties.getBindings().entrySet()) {
                if (!destination.equals(((BindingProperties)entry.getValue()).getDestination())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Found a channel named [{}] with destination [{}]", entry.getKey(), (Object)destination);
                }
                return (String)entry.getKey();
            }
        }
        catch (Exception e) {
            log.error("Exception took place while trying to resolve the destination. Will assume the name [" + destination + "]", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("No destination named [" + destination + "] was found. Assuming that the destination equals the channel name", (Object)destination);
        }
        return destination;
    }

    @Override
    public Message<?> receive(String destination) {
        return this.receive(destination, 5L, TimeUnit.SECONDS);
    }
}

