/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.BasicStringConverter;
import org.springframework.cloud.function.web.RequestProcessor;
import org.springframework.cloud.function.web.StringConverter;
import org.springframework.cloud.function.web.flux.FunctionController;
import org.springframework.cloud.function.web.flux.FunctionHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Flux.class, AsyncHandlerMethodReturnValueHandler.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@Import(value={FunctionController.class, RequestProcessor.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, GsonAutoConfiguration.class})
public class ReactorAutoConfiguration {
    @Bean
    public FunctionHandlerMapping functionHandlerMapping(FunctionCatalog catalog, FunctionController controller) {
        return new FunctionHandlerMapping(catalog, controller);
    }

    @Bean
    @ConditionalOnMissingBean
    public StringConverter functionStringConverter(ConfigurableListableBeanFactory beanFactory) {
        return new BasicStringConverter(beanFactory);
    }
}

