/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.support;

import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.core.env.Environment;

public final class LoadBalancerEnvironmentPropertyUtils {
    private LoadBalancerEnvironmentPropertyUtils() {
        throw new UnsupportedOperationException("Cannot instantiate a utility class");
    }

    public static boolean trueForClientOrDefault(Environment environment, String propertySuffix) {
        return LoadBalancerEnvironmentPropertyUtils.equalToForClientOrDefault(environment, propertySuffix, Boolean.TRUE.toString());
    }

    public static boolean equalToForClientOrDefault(Environment environment, String propertySuffix, String expectedPropertyValue) {
        String defaultValue = LoadBalancerEnvironmentPropertyUtils.getDefaultPropertyValue(environment, propertySuffix);
        String clientValue = LoadBalancerEnvironmentPropertyUtils.getClientPropertyValue(environment, propertySuffix);
        if (clientValue != null && clientValue.equalsIgnoreCase(expectedPropertyValue)) {
            return true;
        }
        return clientValue == null && defaultValue != null && defaultValue.equalsIgnoreCase(expectedPropertyValue);
    }

    public static boolean equalToOrMissingForClientOrDefault(Environment environment, String propertySuffix, String expectedPropertyValue) {
        String defaultValue = LoadBalancerEnvironmentPropertyUtils.getDefaultPropertyValue(environment, propertySuffix);
        String clientValue = LoadBalancerEnvironmentPropertyUtils.getClientPropertyValue(environment, propertySuffix);
        if (clientValue != null && clientValue.equalsIgnoreCase(expectedPropertyValue)) {
            return true;
        }
        if (clientValue == null && defaultValue != null && defaultValue.equalsIgnoreCase(expectedPropertyValue)) {
            return true;
        }
        return clientValue == null && defaultValue == null;
    }

    public static boolean trueOrMissingForClientOrDefault(Environment environment, String propertySuffix) {
        return LoadBalancerEnvironmentPropertyUtils.equalToOrMissingForClientOrDefault(environment, propertySuffix, Boolean.TRUE.toString());
    }

    private static String getClientPropertyValue(Environment environment, String propertySuffix) {
        return environment.getProperty("spring.cloud.loadbalancer.clients." + LoadBalancerClientFactory.getName(environment) + "." + propertySuffix);
    }

    private static String getDefaultPropertyValue(Environment environment, String propertySuffix) {
        return environment.getProperty("spring.cloud.loadbalancer." + propertySuffix);
    }
}

