/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.mvc;

import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.docs.AssertingSpanCustomizer;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.web.mvc.SleuthMvcSpan;
import org.springframework.cloud.sleuth.instrument.web.mvc.WebMvcRuntime;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public class HandlerParser {
    public static final HandlerParser NOOP = new HandlerParser(){

        @Override
        protected void preHandle(HttpServletRequest request, Object handler, SpanCustomizer customizer) {
        }

        @Override
        protected void postHandle(HttpServletRequest request, Object handler, ModelAndView modelAndView, SpanCustomizer customizer) {
        }
    };
    public static final String CONTROLLER_CLASS = SleuthMvcSpan.Tags.CLASS.getKey();
    public static final String CONTROLLER_METHOD = SleuthMvcSpan.Tags.METHOD.getKey();

    protected void preHandle(HttpServletRequest request, Object handler, SpanCustomizer customizer) {
        AssertingSpanCustomizer span = SleuthMvcSpan.MVC_HANDLER_INTERCEPTOR_SPAN.wrap(customizer);
        if (WebMvcRuntime.get().isHandlerMethod(handler)) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            span.tag((TagKey)SleuthMvcSpan.Tags.CLASS, handlerMethod.getBeanType().getSimpleName());
            span.tag((TagKey)SleuthMvcSpan.Tags.METHOD, handlerMethod.getMethod().getName());
        } else {
            span.tag((TagKey)SleuthMvcSpan.Tags.CLASS, handler.getClass().getSimpleName());
        }
    }

    protected void postHandle(HttpServletRequest request, Object handler, ModelAndView modelAndView, SpanCustomizer customizer) {
    }
}

