/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.baggage;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"spring.sleuth.baggage.remote-fields[0]=foo", "spring.sleuth.propagation.type=W3C"})
public abstract class W3CBaggageTests {
    @Autowired
    Tracer tracer;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MockWebServer mockWebServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldProduceOnlyW3cBaggageEntries() throws InterruptedException {
        this.mockWebServer.enqueue(new MockResponse().setBody("hello"));
        Span span = this.tracer.nextSpan();
        try (Tracer.SpanInScope spanInScope = this.tracer.withSpan(span.start());){
            try (BaggageInScope bs = this.tracer.createBaggage("foo").set("bar");){
                this.restTemplate.getForObject(this.mockWebServer.url("/baggage").toString(), String.class, new Object[0]);
                RecordedRequest request = this.mockWebServer.takeRequest(1L, TimeUnit.SECONDS);
                Map map = request.getHeaders().toMultimap();
                BDDAssertions.then((Map)map).doesNotContainKey((Object)"foo");
                List baggage = (List)map.get("baggage");
                BDDAssertions.then((boolean)baggage.stream().anyMatch(s -> s.contains("foo=bar"))).isTrue();
            }
            finally {
                span.end();
            }
        }
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        RestTemplate restTemplate() {
            return new RestTemplate();
        }

        @Bean
        MockWebServer mockWebServer() throws IOException {
            MockWebServer mockWebServer = new MockWebServer();
            mockWebServer.start();
            return mockWebServer;
        }
    }
}

