/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.BindingTargetFactory;
import org.springframework.cloud.stream.binding.BoundTargetHolder;
import org.springframework.util.StringUtils;

public class AbstractBindableProxyFactory
implements Bindable {
    private static Log log = LogFactory.getLog(AbstractBindableProxyFactory.class);
    @Value(value="${spring.cloud.stream.internal.namespace:}")
    private String namespace;
    @Autowired
    protected Map<String, BindingTargetFactory> bindingTargetFactories;
    protected Map<String, BoundTargetHolder> inputHolders = new LinkedHashMap<String, BoundTargetHolder>();
    protected Map<String, BoundTargetHolder> outputHolders = new LinkedHashMap<String, BoundTargetHolder>();
    protected Class<?> type;

    public AbstractBindableProxyFactory(Class<?> type) {
        this.type = type;
    }

    protected BindingTargetFactory getBindingTargetFactory(Class<?> bindingTargetType) {
        ArrayList<String> candidateBindingTargetFactories = new ArrayList<String>();
        for (Map.Entry<String, BindingTargetFactory> bindingTargetFactoryEntry : this.bindingTargetFactories.entrySet()) {
            if (!bindingTargetFactoryEntry.getValue().canCreate(bindingTargetType)) continue;
            candidateBindingTargetFactories.add(bindingTargetFactoryEntry.getKey());
        }
        if (candidateBindingTargetFactories.size() == 1) {
            return this.bindingTargetFactories.get(candidateBindingTargetFactories.get(0));
        }
        if (candidateBindingTargetFactories.size() == 0) {
            throw new IllegalStateException("No factory found for binding target type: " + bindingTargetType.getName() + " among registered factories: " + StringUtils.collectionToCommaDelimitedString(this.bindingTargetFactories.keySet()));
        }
        throw new IllegalStateException("Multiple factories found for binding target type: " + bindingTargetType.getName() + ": " + StringUtils.collectionToCommaDelimitedString(candidateBindingTargetFactories));
    }

    @Override
    public Collection<Binding<Object>> createAndBindInputs(BindingService bindingService) {
        ArrayList<Binding<Object>> bindings = new ArrayList<Binding<Object>>();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Binding inputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.inputHolders.entrySet()) {
            String inputTargetName = boundTargetHolderEntry.getKey();
            BoundTargetHolder boundTargetHolder = boundTargetHolderEntry.getValue();
            if (!boundTargetHolder.isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.namespace, this.type, inputTargetName));
            }
            bindings.addAll(bindingService.bindConsumer(boundTargetHolder.getBoundTarget(), inputTargetName));
        }
        return bindings;
    }

    @Override
    public Collection<Binding<Object>> createAndBindOutputs(BindingService bindingService) {
        ArrayList<Binding<Object>> bindings = new ArrayList<Binding<Object>>();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Binding outputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.outputHolders.entrySet()) {
            BoundTargetHolder boundTargetHolder = boundTargetHolderEntry.getValue();
            String outputTargetName = boundTargetHolderEntry.getKey();
            if (!boundTargetHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.namespace, this.type, outputTargetName));
            }
            bindings.add(bindingService.bindProducer(boundTargetHolder.getBoundTarget(), outputTargetName));
        }
        return bindings;
    }

    @Override
    public void unbindInputs(BindingService bindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unbinding inputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.inputHolders.entrySet()) {
            if (!boundTargetHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unbinding %s:%s:%s", this.namespace, this.type, boundTargetHolderEntry.getKey()));
            }
            bindingService.unbindConsumers(boundTargetHolderEntry.getKey());
        }
    }

    @Override
    public void unbindOutputs(BindingService bindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unbinding outputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.outputHolders.entrySet()) {
            if (!boundTargetHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.namespace, this.type, boundTargetHolderEntry.getKey()));
            }
            bindingService.unbindProducers(boundTargetHolderEntry.getKey());
        }
    }

    @Override
    public Set<String> getInputs() {
        return this.inputHolders.keySet();
    }

    @Override
    public Set<String> getOutputs() {
        return this.outputHolders.keySet();
    }
}

