/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.cloud.stream.binding.StreamListenerParameterAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface StreamListenerSetupMethodOrchestrator {
    public boolean supports(Method var1);

    public void orchestrateStreamListenerSetupMethod(StreamListener var1, Method var2, Object var3);

    default public Object[] adaptAndRetrieveInboundArguments(Method method, String inboundName, ApplicationContext applicationContext, StreamListenerParameterAdapter ... streamListenerParameterAdapters) {
        Object[] arguments = new Object[method.getParameterTypes().length];
        for (int parameterIndex = 0; parameterIndex < arguments.length; ++parameterIndex) {
            Object targetBean;
            MethodParameter methodParameter = MethodParameter.forExecutable((Executable)method, (int)parameterIndex);
            Class parameterType = methodParameter.getParameterType();
            Object targetReferenceValue = null;
            if (methodParameter.hasParameterAnnotation(Input.class)) {
                targetReferenceValue = AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Input.class));
            } else if (methodParameter.hasParameterAnnotation(Output.class)) {
                targetReferenceValue = AnnotationUtils.getValue((Annotation)methodParameter.getParameterAnnotation(Output.class));
            } else if (arguments.length == 1 && StringUtils.hasText((String)inboundName)) {
                targetReferenceValue = inboundName;
            }
            if (targetReferenceValue != null) {
                Assert.isInstanceOf(String.class, (Object)targetReferenceValue, (String)"Annotation value must be a String");
                targetBean = applicationContext.getBean((String)targetReferenceValue);
                for (StreamListenerParameterAdapter streamListenerParameterAdapter : streamListenerParameterAdapters) {
                    if (!streamListenerParameterAdapter.supports(targetBean.getClass(), methodParameter)) continue;
                    arguments[parameterIndex] = streamListenerParameterAdapter.adapt(targetBean, methodParameter);
                    break;
                }
                if (arguments[parameterIndex] == null && parameterType.isAssignableFrom(targetBean.getClass())) {
                    arguments[parameterIndex] = targetBean;
                }
            } else {
                throw new IllegalStateException("A method annotated with @StreamListener may use @Input or @Output annotations only in declarative mode and for parameters that are binding targets or convertible from binding targets.");
            }
            Assert.notNull((Object)arguments[parameterIndex], (String)("Cannot convert argument " + parameterIndex + " of " + method + "from " + targetBean.getClass() + " to " + parameterType));
        }
        return arguments;
    }
}

