/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.cloud.task.batch.listener.support.JobExecutionEvent;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.core.Ordered;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingJobExecutionListener
implements JobExecutionListener,
Ordered {
    private MessagePublisher<JobExecutionEvent> messagePublisher;
    private int order = Integer.MAX_VALUE;

    public EventEmittingJobExecutionListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public EventEmittingJobExecutionListener(MessageChannel output, int order) {
        this(output);
        this.order = order;
    }

    public void beforeJob(JobExecution jobExecution) {
        this.messagePublisher.publish(new JobExecutionEvent(jobExecution));
    }

    public void afterJob(JobExecution jobExecution) {
        this.messagePublisher.publish(new JobExecutionEvent(jobExecution));
    }

    public int getOrder() {
        return this.order;
    }
}

