/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import org.hibernate.envers.RevisionNumber;
import org.springframework.data.repository.history.support.RevisionEntityInformation;
import org.springframework.data.util.AnnotationDetectionFieldCallback;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionRevisionEntityInformation
implements RevisionEntityInformation {
    private final Class<?> revisionEntityClass;
    private final Class<?> revisionNumberType;

    public ReflectionRevisionEntityInformation(Class<?> revisionEntityClass) {
        Assert.notNull(revisionEntityClass, (String)"Revision entity type must not be null!");
        AnnotationDetectionFieldCallback fieldCallback = new AnnotationDetectionFieldCallback(RevisionNumber.class);
        ReflectionUtils.doWithFields(revisionEntityClass, (ReflectionUtils.FieldCallback)fieldCallback);
        this.revisionNumberType = fieldCallback.getRequiredType();
        this.revisionEntityClass = revisionEntityClass;
    }

    public boolean isDefaultRevisionEntity() {
        return false;
    }

    public Class<?> getRevisionEntityClass() {
        return this.revisionEntityClass;
    }

    public Class<?> getRevisionNumberType() {
        return this.revisionNumberType;
    }
}

