/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.HibernateQueryInformation;
import org.springframework.data.jpa.repository.query.HqlBaseVisitor;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryRenderer;
import org.springframework.data.jpa.repository.query.ParsedQueryIntrospector;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryInformationHolder;

class HqlQueryIntrospector
extends HqlBaseVisitor<Void>
implements ParsedQueryIntrospector<HibernateQueryInformation> {
    private final HqlQueryRenderer renderer = new HqlQueryRenderer();
    private final QueryInformationHolder introspection = new QueryInformationHolder();
    private boolean hasCte = false;
    private boolean hasFromFunction = false;

    HqlQueryIntrospector() {
    }

    @Override
    public HibernateQueryInformation getParsedQueryInformation() {
        return new HibernateQueryInformation(this.introspection, this.hasCte, this.hasFromFunction);
    }

    @Override
    public Void visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.SELECT);
        return (Void)super.visitSelectStatement(ctx);
    }

    @Override
    public Void visitFromQuery(HqlParser.FromQueryContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.SELECT);
        return (Void)super.visitFromQuery(ctx);
    }

    @Override
    public Void visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.INSERT);
        return (Void)super.visitInsertStatement(ctx);
    }

    @Override
    public Void visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.UPDATE);
        return (Void)super.visitUpdateStatement(ctx);
    }

    @Override
    public Void visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.DELETE);
        return (Void)super.visitDeleteStatement(ctx);
    }

    @Override
    public Void visitSelectClause(HqlParser.SelectClauseContext ctx) {
        this.introspection.captureProjection(ctx.selectionList().selection(), this.renderer::visitSelection);
        return (Void)super.visitSelectClause(ctx);
    }

    @Override
    public Void visitCte(HqlParser.CteContext ctx) {
        this.hasCte = true;
        return (Void)super.visitCte(ctx);
    }

    @Override
    public Void visitRootEntity(HqlParser.RootEntityContext ctx) {
        if (ctx.variable() != null && !HqlQueryRenderer.isSubquery(ctx) && !HqlQueryRenderer.isSetQuery(ctx)) {
            this.capturePrimaryAlias(ctx.variable());
        }
        return (Void)super.visitRootEntity(ctx);
    }

    @Override
    public Void visitRootSubquery(HqlParser.RootSubqueryContext ctx) {
        if (ctx.variable() != null && !HqlQueryRenderer.isSubquery(ctx) && !HqlQueryRenderer.isSetQuery(ctx)) {
            this.capturePrimaryAlias(ctx.variable());
        }
        return (Void)super.visitRootSubquery(ctx);
    }

    @Override
    public Void visitRootFunction(HqlParser.RootFunctionContext ctx) {
        if (ctx.variable() != null && !HqlQueryRenderer.isSubquery(ctx) && !HqlQueryRenderer.isSetQuery(ctx)) {
            this.capturePrimaryAlias(ctx.variable());
            this.hasFromFunction = true;
        }
        return (Void)super.visitRootFunction(ctx);
    }

    @Override
    public Void visitInstantiation(HqlParser.InstantiationContext ctx) {
        this.introspection.constructorExpressionPresent();
        return (Void)super.visitInstantiation(ctx);
    }

    private void capturePrimaryAlias(HqlParser.VariableContext ctx) {
        this.introspection.capturePrimaryAlias((ctx.nakedIdentifier() != null ? ctx.nakedIdentifier() : ctx.identifier()).getText());
    }
}

