/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.BinaryVector;
import org.bson.Document;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Vector;
import org.springframework.data.mongodb.core.aggregation.AddFieldsOperation;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.mapping.MongoVector;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class VectorSearchOperation
implements AggregationOperation {
    private final SearchType searchType;
    @Nullable
    private final CriteriaDefinition filter;
    private final String indexName;
    private final Limit limit;
    @Nullable
    private final Integer numCandidates;
    private final QueryPaths path;
    private final Vector vector;
    private final String score;
    private final Consumer<Criteria> scoreCriteria;

    private VectorSearchOperation(SearchType searchType, @Nullable CriteriaDefinition filter, String indexName, Limit limit, @Nullable Integer numCandidates, QueryPaths path, Vector vector, @Nullable String searchScore, Consumer<Criteria> scoreCriteria) {
        this.searchType = searchType;
        this.filter = filter;
        this.indexName = indexName;
        this.limit = limit;
        this.numCandidates = numCandidates;
        this.path = path;
        this.vector = vector;
        this.score = searchScore;
        this.scoreCriteria = scoreCriteria;
    }

    VectorSearchOperation(String indexName, QueryPaths path, Limit limit, Vector vector) {
        this(SearchType.DEFAULT, null, indexName, limit, null, path, vector, null, null);
    }

    public static PathContributor search(String index) {
        return new VectorSearchBuilder().index(index);
    }

    @Contract(value="_ -> new")
    public VectorSearchOperation searchType(SearchType searchType) {
        return new VectorSearchOperation(searchType, this.filter, this.indexName, this.limit, this.numCandidates, this.path, this.vector, this.score, this.scoreCriteria);
    }

    @Contract(value="_ -> new")
    public VectorSearchOperation filter(CriteriaDefinition filter) {
        return new VectorSearchOperation(this.searchType, filter, this.indexName, this.limit, this.numCandidates, this.path, this.vector, this.score, this.scoreCriteria);
    }

    @Contract(value="_ -> new")
    public VectorSearchOperation filter(final Document filter) {
        return this.filter(new CriteriaDefinition(){

            @Override
            public Document getCriteriaObject() {
                return filter;
            }

            @Override
            @Nullable
            public String getKey() {
                return null;
            }
        });
    }

    @Contract(value="_ -> new")
    public VectorSearchOperation numCandidates(int numCandidates) {
        return new VectorSearchOperation(this.searchType, this.filter, this.indexName, this.limit, numCandidates, this.path, this.vector, this.score, this.scoreCriteria);
    }

    @Contract(value="-> new")
    public VectorSearchOperation withSearchScore() {
        return this.withSearchScore("score");
    }

    @Contract(value="_ -> new")
    public VectorSearchOperation withSearchScore(String scoreFieldName) {
        return new VectorSearchOperation(this.searchType, this.filter, this.indexName, this.limit, this.numCandidates, this.path, this.vector, scoreFieldName, this.scoreCriteria);
    }

    @Contract(value="_ -> new")
    public VectorSearchOperation withFilterBySore(Consumer<Criteria> score) {
        return new VectorSearchOperation(this.searchType, this.filter, this.indexName, this.limit, this.numCandidates, this.path, this.vector, StringUtils.hasText((String)this.score) ? this.score : "score", score);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        List source;
        Object path;
        Document $vectorSearch = new Document();
        if (this.searchType != null && !this.searchType.equals((Object)SearchType.DEFAULT)) {
            $vectorSearch.append("exact", (Object)this.searchType.equals((Object)SearchType.ENN));
        }
        if (this.filter != null) {
            $vectorSearch.append("filter", (Object)context.getMappedObject(this.filter.getCriteriaObject()));
        }
        $vectorSearch.append("index", (Object)this.indexName);
        if (this.limit.isLimited()) {
            $vectorSearch.append("limit", (Object)this.limit.max());
        }
        if (this.numCandidates != null) {
            $vectorSearch.append("numCandidates", (Object)this.numCandidates);
        }
        if ((path = this.path.getPathObject()) instanceof String) {
            String pathFieldName = (String)path;
            Document mappedObject = context.getMappedObject(new Document(pathFieldName, (Object)1));
            path = mappedObject.keySet().iterator().next();
        }
        if ((source = this.vector.getSource()) instanceof float[]) {
            source = (List)this.vector.toDoubleArray();
        }
        if (source instanceof double[]) {
            double[] ds = (double[])source;
            source = Arrays.stream(ds).boxed().collect(Collectors.toList());
        }
        $vectorSearch.append("path", path);
        $vectorSearch.append("queryVector", source);
        return new Document(this.getOperator(), (Object)$vectorSearch);
    }

    @Override
    public List<Document> toPipelineStages(AggregationOperationContext context) {
        if (!StringUtils.hasText((String)this.score)) {
            return List.of(this.toDocument(context));
        }
        AddFieldsOperation $vectorSearchScore = Aggregation.addFields().addField(this.score).withValueOfExpression("{\"$meta\":\"vectorSearchScore\"}", new Object[0]).build();
        if (this.scoreCriteria == null) {
            return List.of(this.toDocument(context), $vectorSearchScore.toDocument(context));
        }
        Criteria criteria = Criteria.where(this.score);
        this.scoreCriteria.accept(criteria);
        MatchOperation $filterByScore = Aggregation.match(criteria);
        return List.of(this.toDocument(context), $vectorSearchScore.toDocument(context), $filterByScore.toDocument(context));
    }

    @Override
    public String getOperator() {
        return "$vectorSearch";
    }

    public static enum SearchType {
        DEFAULT,
        ANN,
        ENN;

    }

    public static class QueryPaths {
        private final Set<QueryPath<?>> paths;

        private QueryPaths(Set<QueryPath<?>> paths) {
            this.paths = paths;
        }

        public static QueryPaths of(QueryPath<String> path) {
            return new QueryPaths(Set.of(path));
        }

        Object getPathObject() {
            if (this.paths.size() == 1) {
                return this.paths.iterator().next().value();
            }
            return this.paths.stream().map(QueryPath::value).collect(Collectors.toList());
        }
    }

    private static class VectorSearchBuilder
    implements PathContributor,
    VectorContributor,
    LimitContributor {
        String index;
        QueryPath<String> paths;
        Vector vector;

        private VectorSearchBuilder() {
        }

        PathContributor index(String index) {
            this.index = index;
            return this;
        }

        @Override
        public VectorContributor path(String path) {
            this.paths = QueryPath.path(path);
            return this;
        }

        @Override
        public VectorSearchOperation limit(Limit limit) {
            return new VectorSearchOperation(this.index, QueryPaths.of(this.paths), limit, this.vector);
        }

        @Override
        public LimitContributor vector(Vector vector) {
            this.vector = vector;
            return this;
        }
    }

    public static interface PathContributor {
        @Contract(value="_ -> this")
        public VectorContributor path(String var1);
    }

    public static interface LimitContributor {
        @Contract(value="_ -> this")
        default public VectorSearchOperation limit(int limit) {
            return this.limit(Limit.of((int)limit));
        }

        @Contract(value="_ -> this")
        public VectorSearchOperation limit(Limit var1);
    }

    public static interface VectorContributor {
        @Contract(value="_ -> this")
        default public LimitContributor vector(float ... vector) {
            return this.vector(Vector.of((float[])vector));
        }

        @Contract(value="_ -> this")
        default public LimitContributor vector(byte[] vector) {
            return this.vector((BinaryVector)BinaryVector.int8Vector((byte[])vector));
        }

        @Contract(value="_ -> this")
        default public LimitContributor vector(double ... vector) {
            return this.vector(Vector.of((double[])vector));
        }

        @Contract(value="_ -> this")
        default public LimitContributor vector(List<? extends Number> vector) {
            return this.vector(Vector.of(vector));
        }

        @Contract(value="_ -> this")
        default public LimitContributor vector(BinaryVector vector) {
            return this.vector(MongoVector.of(vector));
        }

        @Contract(value="_ -> this")
        public LimitContributor vector(Vector var1);
    }

    public static class SimplePath
    implements QueryPath<String> {
        String name;

        public SimplePath(String name) {
            this.name = name;
        }

        @Override
        public String value() {
            return this.name;
        }
    }

    public static interface QueryPath<T> {
        public T value();

        public static QueryPath<String> path(String field) {
            return new SimplePath(field);
        }
    }
}

