/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.support.PagingAndSortingTemplateVariables;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

class ArgumentResolverPagingAndSortingTemplateVariables
implements PagingAndSortingTemplateVariables {
    private static final Set<Class<?>> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Pageable.class, Sort.class)));
    private final HateoasPageableHandlerMethodArgumentResolver pagingResolver;
    private final HateoasSortHandlerMethodArgumentResolver sortResolver;

    public ArgumentResolverPagingAndSortingTemplateVariables(HateoasPageableHandlerMethodArgumentResolver pagingResolver, HateoasSortHandlerMethodArgumentResolver sortResolver) {
        Assert.notNull((Object)pagingResolver, (String)"HateoasPageableHandlerMethodArgumentResolver must not be null");
        Assert.notNull((Object)sortResolver, (String)"HateoasSortHandlerMethodArgumentResolver must not be null");
        this.pagingResolver = pagingResolver;
        this.sortResolver = sortResolver;
    }

    @Override
    public TemplateVariables getPaginationTemplateVariables(@Nullable MethodParameter parameter, UriComponents components) {
        return this.pagingResolver.getPaginationTemplateVariables(parameter, components);
    }

    @Override
    public TemplateVariables getSortTemplateVariables(@Nullable MethodParameter parameter, UriComponents template) {
        return this.sortResolver.getSortTemplateVariables(parameter, template);
    }

    public void enhance(UriComponentsBuilder builder, @Nullable MethodParameter parameter, Object value) {
        if (value instanceof Pageable) {
            this.pagingResolver.enhance(builder, parameter, value);
        } else if (value instanceof Sort) {
            this.sortResolver.enhance(builder, parameter, value);
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return SUPPORTED_TYPES.contains(parameter.getParameterType());
    }
}

