/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.List;
import org.jspecify.annotations.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.config.HypermediaWebClientConfigurer;
import org.springframework.hateoas.config.WebfluxCodecCustomizer;
import org.springframework.web.reactive.function.client.WebClient;
import tools.jackson.databind.json.JsonMapper;

@Configuration(proxyBeanMethods=false)
class WebClientHateoasConfiguration {
    WebClientHateoasConfiguration() {
    }

    @Bean
    @Lazy
    HypermediaWebClientConfigurer webClientConfigurer(ObjectProvider<JsonMapper> mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        WebfluxCodecCustomizer withGenericJsonTypes = new WebfluxCodecCustomizer(hypermediaTypes, (JsonMapper)mapper.getIfAvailable(JsonMapper::new)).withGenericJsonTypes();
        return new HypermediaWebClientConfigurer(withGenericJsonTypes);
    }

    @Bean
    static HypermediaWebClientBeanPostProcessor webClientBeanPostProcessor(ObjectFactory<HypermediaWebClientConfigurer> configurer) {
        return new HypermediaWebClientBeanPostProcessor(configurer);
    }

    static class HypermediaWebClientBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectFactory<HypermediaWebClientConfigurer> configurer;

        public HypermediaWebClientBeanPostProcessor(ObjectFactory<HypermediaWebClientConfigurer> configurer) {
            this.configurer = configurer;
        }

        public @NonNull Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return !WebClient.class.isInstance(bean) ? bean : ((HypermediaWebClientConfigurer)this.configurer.getObject()).registerHypermediaTypes(((WebClient)bean).mutate()).build();
        }
    }
}

