/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.file.filters.DiscardAwareFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.util.Assert;

public class CompositeFileListFilter<F>
implements ReversibleFileListFilter<F>,
ResettableFileListFilter<F>,
DiscardAwareFileListFilter<F>,
Closeable {
    protected final Set<FileListFilter<F>> fileFilters;
    private Consumer<F> discardCallback;
    private boolean allSupportAccept = true;
    private boolean oneIsForRecursion;
    private final Lock lock = new ReentrantLock();

    public CompositeFileListFilter() {
        this.fileFilters = new LinkedHashSet<FileListFilter<F>>();
    }

    public CompositeFileListFilter(Collection<? extends FileListFilter<F>> fileFilters) {
        this.fileFilters = new LinkedHashSet<FileListFilter<F>>(fileFilters);
        this.allSupportAccept = fileFilters.stream().allMatch(FileListFilter::supportsSingleFileFiltering);
        this.oneIsForRecursion = fileFilters.stream().anyMatch(FileListFilter::isForRecursion);
    }

    @Override
    public boolean isForRecursion() {
        return this.oneIsForRecursion;
    }

    @Override
    public void close() throws IOException {
        for (FileListFilter<F> filter : this.fileFilters) {
            if (!(filter instanceof Closeable)) continue;
            ((Closeable)((Object)filter)).close();
        }
    }

    public CompositeFileListFilter<F> addFilter(FileListFilter<F> filter) {
        return this.addFilters(Collections.singletonList(filter));
    }

    @SafeVarargs
    public final CompositeFileListFilter<F> addFilters(FileListFilter<F> ... filters) {
        List<FileListFilter<F>> asList = Arrays.asList(filters);
        return this.addFilters(asList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeFileListFilter<F> addFilters(Collection<? extends FileListFilter<F>> filtersToAdd) {
        this.lock.lock();
        try {
            for (FileListFilter<F> elf : filtersToAdd) {
                if (elf instanceof DiscardAwareFileListFilter) {
                    ((DiscardAwareFileListFilter)elf).addDiscardCallback(this.discardCallback);
                }
                if (elf instanceof InitializingBean) {
                    try {
                        ((InitializingBean)elf).afterPropertiesSet();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.allSupportAccept = this.allSupportAccept && elf.supportsSingleFileFiltering();
                this.oneIsForRecursion |= elf.isForRecursion();
            }
            this.fileFilters.addAll(filtersToAdd);
            CompositeFileListFilter compositeFileListFilter = this;
            return compositeFileListFilter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addDiscardCallback(Consumer<F> discardCallbackToSet) {
        this.discardCallback = discardCallbackToSet;
        if (this.discardCallback != null) {
            this.fileFilters.stream().filter(DiscardAwareFileListFilter.class::isInstance).map(f -> (DiscardAwareFileListFilter)f).forEach(f -> f.addDiscardCallback(discardCallbackToSet));
        }
    }

    @Override
    public List<F> filterFiles(F[] files) {
        Assert.notNull(files, (String)"'files' should not be null");
        ArrayList<F> results = new ArrayList<F>(Arrays.asList(files));
        for (FileListFilter<F> fileFilter : this.fileFilters) {
            List<F> currentResults = fileFilter.filterFiles(files);
            results.retainAll(currentResults);
        }
        return results;
    }

    @Override
    public boolean accept(F file) {
        AtomicBoolean allAccept = new AtomicBoolean(true);
        this.fileFilters.forEach(f -> allAccept.compareAndSet(true, f.accept(file)));
        return allAccept.get();
    }

    @Override
    public boolean supportsSingleFileFiltering() {
        return this.allSupportAccept;
    }

    @Override
    public void rollback(F file, List<F> files) {
        for (FileListFilter<F> fileFilter : this.fileFilters) {
            if (!(fileFilter instanceof ReversibleFileListFilter)) continue;
            ((ReversibleFileListFilter)fileFilter).rollback(file, files);
        }
    }

    @Override
    public boolean remove(F f) {
        boolean removed = false;
        for (FileListFilter<F> fileFilter : this.fileFilters) {
            if (!(fileFilter instanceof ResettableFileListFilter)) continue;
            ((ResettableFileListFilter)fileFilter).remove(f);
            removed = true;
        }
        return removed;
    }
}

