/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.IgnoreHiddenFileListFilter;
import org.springframework.messaging.MessagingException;

public class DefaultDirectoryScanner
implements DirectoryScanner {
    private volatile @Nullable FileListFilter<File> filter;
    private volatile @Nullable FileLocker locker;

    public DefaultDirectoryScanner() {
        ArrayList<AbstractFileListFilter> defaultFilters = new ArrayList<AbstractFileListFilter>(2);
        defaultFilters.add(new IgnoreHiddenFileListFilter());
        defaultFilters.add(new AcceptOnceFileListFilter());
        this.filter = new CompositeFileListFilter<File>(defaultFilters);
    }

    @Override
    public void setFilter(FileListFilter<File> filter) {
        this.filter = filter;
    }

    protected @Nullable FileListFilter<File> getFilter() {
        return this.filter;
    }

    @Override
    public final void setLocker(FileLocker locker) {
        this.locker = locker;
    }

    protected @Nullable FileLocker getLocker() {
        return this.locker;
    }

    @Override
    public boolean tryClaim(File file) {
        FileLocker lockerToUse = this.locker;
        return lockerToUse == null || lockerToUse.lock(file);
    }

    @Override
    public List<File> listFiles(File directory) throws IllegalArgumentException {
        File @Nullable [] files = this.listEligibleFiles(directory);
        if (files == null) {
            throw new MessagingException("The path [" + String.valueOf(directory) + "] does not denote a properly accessible directory.");
        }
        FileListFilter<File> filterToUse = this.filter;
        return filterToUse != null ? filterToUse.filterFiles((File[])files) : Arrays.asList(files);
    }

    protected File @Nullable [] listEligibleFiles(File directory) {
        return directory.listFiles();
    }
}

