/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.util.Assert;

public class ChainFileListFilter<F>
extends CompositeFileListFilter<F> {
    public ChainFileListFilter() {
    }

    public ChainFileListFilter(Collection<? extends FileListFilter<F>> fileFilters) {
        super(fileFilters);
    }

    @Override
    public List<F> filterFiles(F @Nullable [] files) {
        Assert.notNull(files, (String)"'files' should not be null");
        List<Object> leftOver = Arrays.asList(files);
        for (FileListFilter fileFilter : this.fileFilters) {
            if (leftOver.isEmpty()) break;
            Object[] fileArray = leftOver.toArray((Object[])Array.newInstance(leftOver.get(0).getClass(), leftOver.size()));
            leftOver = fileFilter.filterFiles(fileArray);
        }
        return leftOver;
    }

    @Override
    public boolean accept(F file) {
        for (FileListFilter filter : this.fileFilters) {
            if (filter.accept(file)) continue;
            return false;
        }
        return true;
    }
}

