/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.splitter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.util.FunctionIterator;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.xml.DocumentBuilderFactoryUtils;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.TransformerFactoryUtils;
import org.springframework.xml.xpath.XPathException;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.springframework.xml.xpath.XPathParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathMessageSplitter
extends AbstractMessageSplitter {
    private final TransformerFactory transformerFactory;
    private final Lock documentBuilderFactoryMonitor = new ReentrantLock();
    private final Lock transformerFactoryMonitor = new ReentrantLock();
    private final XPathExpression xpathExpression;
    private @Nullable javax.xml.xpath.XPathExpression jaxpExpression;
    private boolean createDocuments;
    private DocumentBuilderFactory documentBuilderFactory;
    private XmlPayloadConverter xmlPayloadConverter = new DefaultXmlPayloadConverter();
    private @Nullable Properties outputProperties;
    private boolean returnIterator = true;

    public XPathMessageSplitter(String expression) {
        this(expression, new HashMap<String, String>());
    }

    public XPathMessageSplitter(String expression, TransformerFactory transformerFactory) {
        this(expression, new HashMap<String, String>(), transformerFactory);
    }

    public XPathMessageSplitter(String expression, Map<String, String> namespaces) {
        this(expression, namespaces, TransformerFactoryUtils.newInstance());
    }

    public XPathMessageSplitter(String expression, Map<String, String> namespaces, TransformerFactory transformerFactory) {
        this(XPathExpressionFactory.createXPathExpression((String)expression, namespaces), transformerFactory);
        XPath xpath = XPathFactory.newInstance().newXPath();
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.setBindings(namespaces);
        xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        try {
            this.jaxpExpression = xpath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new XPathParseException("Could not compile [" + expression + "] to a XPathExpression: " + e.getMessage(), (Throwable)e);
        }
    }

    public XPathMessageSplitter(XPathExpression xpathExpression) {
        this(xpathExpression, TransformerFactoryUtils.newInstance());
    }

    public XPathMessageSplitter(XPathExpression xpathExpression, TransformerFactory transformerFactory) {
        Assert.notNull((Object)xpathExpression, (String)"'xpathExpression' must not be null.");
        Assert.notNull((Object)transformerFactory, (String)"'transformerFactory' must not be null.");
        this.xpathExpression = xpathExpression;
        this.transformerFactory = transformerFactory;
        this.documentBuilderFactory = DocumentBuilderFactoryUtils.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public void setCreateDocuments(boolean createDocuments) {
        this.createDocuments = createDocuments;
    }

    public String getComponentType() {
        return "xml:xpath-splitter";
    }

    public void setDocumentBuilder(DocumentBuilderFactory documentBuilderFactory) {
        Assert.notNull((Object)documentBuilderFactory, (String)"DocumentBuilderFactory must not be null");
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void setXmlPayloadConverter(XmlPayloadConverter xmlPayloadConverter) {
        Assert.notNull((Object)xmlPayloadConverter, (String)"XmlPayloadConverter must not be null");
        this.xmlPayloadConverter = xmlPayloadConverter;
    }

    public void setIterator(boolean iterator) {
        this.returnIterator = iterator;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    protected void doInit() {
        super.doInit();
        if (this.returnIterator && this.jaxpExpression == null) {
            this.logger.info((CharSequence)"The 'iterator' option isn't available for an external XPathExpression. Will be ignored");
            this.returnIterator = false;
        }
    }

    protected Object splitMessage(Message<?> message) {
        try {
            Object result;
            Object payload = message.getPayload();
            if (payload instanceof Node) {
                Node node = (Node)payload;
                result = this.splitNode(node);
            } else {
                Document document = this.xmlPayloadConverter.convertToDocument(payload);
                Assert.notNull((Object)document, () -> "unsupported payload type [" + payload.getClass().getName() + "]");
                result = this.splitDocument(document);
            }
            return result;
        }
        catch (ParserConfigurationException ex) {
            throw new MessageConversionException(message, "failed to create DocumentBuilder", (Throwable)ex);
        }
        catch (Exception ex) {
            throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Failed to split Message payload in the [" + String.valueOf((Object)this) + "]", (Throwable)ex);
        }
    }

    protected int obtainSizeIfPossible(Iterator<?> iterator) {
        Iterator<Object> theIterator = iterator;
        if (iterator instanceof TransformFunctionIterator) {
            TransformFunctionIterator transformFunctionIterator = (TransformFunctionIterator)((Object)iterator);
            theIterator = transformFunctionIterator.delegate;
        }
        if (theIterator instanceof NodeListIterator) {
            NodeListIterator nodeListIterator = (NodeListIterator)theIterator;
            return nodeListIterator.nodeList.getLength();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object splitDocument(Document document) throws ParserConfigurationException, TransformerException {
        Transformer transformer;
        Object nodes = this.splitNode(document);
        this.transformerFactoryMonitor.lock();
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        finally {
            this.transformerFactoryMonitor.unlock();
        }
        if (this.outputProperties != null) {
            transformer.setOutputProperties(this.outputProperties);
        }
        if (nodes instanceof List) {
            List items = (List)nodes;
            ArrayList<String> splitStrings = new ArrayList<String>(items.size());
            for (Node nodeFromList : items) {
                StringResult result = new StringResult();
                transformer.transform(new DOMSource(nodeFromList), (Result)result);
                splitStrings.add(result.toString());
            }
            return splitStrings;
        }
        return new TransformFunctionIterator((Iterator)nodes, node -> {
            StringResult result = new StringResult();
            try {
                transformer.transform(new DOMSource((Node)node), (Result)result);
            }
            catch (TransformerException e) {
                throw new IllegalStateException("failed to create DocumentBuilder", e);
            }
            return result.toString();
        });
    }

    private Object splitNode(Node node) throws ParserConfigurationException {
        if (this.returnIterator && this.jaxpExpression != null) {
            try {
                NodeList nodeList = (NodeList)this.jaxpExpression.evaluate(node, XPathConstants.NODESET);
                return new NodeListIterator(nodeList);
            }
            catch (XPathExpressionException e) {
                throw new XPathException("Could not evaluate XPath expression:" + e.getMessage(), (Throwable)e);
            }
        }
        List nodeList = this.xpathExpression.evaluateAsNodeList(node);
        if (this.createDocuments) {
            return this.convertNodesToDocuments(nodeList);
        }
        return nodeList;
    }

    private List<Node> convertNodesToDocuments(List<Node> nodes) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getNewDocumentBuilder();
        ArrayList<Node> documents = new ArrayList<Node>(nodes.size());
        for (Node node : nodes) {
            Document document = this.convertNodeToDocument(documentBuilder, node);
            documents.add(document);
        }
        return documents;
    }

    private Document convertNodeToDocument(DocumentBuilder documentBuilder, Node node) {
        Document document = documentBuilder.newDocument();
        document.appendChild(document.importNode(node, true));
        return document;
    }

    private DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        this.documentBuilderFactoryMonitor.lock();
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            return documentBuilder;
        }
        finally {
            this.documentBuilderFactoryMonitor.unlock();
        }
    }

    private static final class TransformFunctionIterator
    extends FunctionIterator<Node, String> {
        private final Iterator<Node> delegate;

        TransformFunctionIterator(Iterator<Node> delegate, Function<? super Node, ? extends String> function) {
            super(null, delegate, function);
            this.delegate = delegate;
        }
    }

    private final class NodeListIterator
    implements Iterator<Node> {
        private final @Nullable DocumentBuilder documentBuilder;
        private final NodeList nodeList;
        private int index;

        NodeListIterator(NodeList nodeList) throws ParserConfigurationException {
            this.nodeList = nodeList;
            this.documentBuilder = XPathMessageSplitter.this.createDocuments ? XPathMessageSplitter.this.getNewDocumentBuilder() : null;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.nodeList.getLength();
        }

        @Override
        public @Nullable Node next() {
            if (!this.hasNext()) {
                return null;
            }
            Node node = this.nodeList.item(this.index++);
            if (this.documentBuilder != null) {
                node = XPathMessageSplitter.this.convertNodeToDocument(this.documentBuilder, node);
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation not supported");
        }
    }
}

