/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.util.Assert;

public class AttributeCheckAttributesMapper
implements AttributesMapper<Object> {
    private String[] expectedAttributes = new String[0];
    private String[] expectedValues = new String[0];
    private String[] absentAttributes = new String[0];

    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        Assert.isTrue((this.expectedAttributes.length == this.expectedValues.length ? 1 : 0) != 0, (String)"Values and attributes need to have the same length");
        for (int i = 0; i < this.expectedAttributes.length; ++i) {
            Attribute attribute = attributes.get(this.expectedAttributes[i]);
            Assert.notNull((Object)attribute, (String)("Attribute " + this.expectedAttributes[i] + " was not present"));
            Object value = attribute.get();
            Assert.isTrue((boolean)this.expectedValues[i].equals(value), (String)("Expected '" + this.expectedValues[i] + "' but got '" + String.valueOf(value) + "'"));
        }
        for (String absentAttribute : this.absentAttributes) {
            Assert.isNull((Object)attributes.get(absentAttribute), (String)("Attribute '" + absentAttribute + "' should not be present"));
        }
        return new Object();
    }

    public void setAbsentAttributes(String[] absentAttributes) {
        this.absentAttributes = Arrays.copyOf(absentAttributes, absentAttributes.length);
    }

    public void setExpectedAttributes(String[] expectedAttributes) {
        this.expectedAttributes = Arrays.copyOf(expectedAttributes, expectedAttributes.length);
    }

    public void setExpectedValues(String[] expectedValues) {
        this.expectedValues = Arrays.copyOf(expectedValues, expectedValues.length);
    }
}

