/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test.unboundid;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.List;
import java.util.function.Consumer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class EmbeddedLdapServer
implements AutoCloseable {
    private final InMemoryDirectoryServer directoryServer;

    public EmbeddedLdapServer(InMemoryDirectoryServer directoryServer) {
        this.directoryServer = directoryServer;
    }

    public static Builder withPartitionSuffix(String partitionSuffix) {
        return new Builder(partitionSuffix);
    }

    @Deprecated(since="3.3")
    public static EmbeddedLdapServer newEmbeddedServer(String defaultPartitionName, String defaultPartitionSuffix, int port) throws Exception {
        EmbeddedLdapServer server = EmbeddedLdapServer.withPartitionSuffix(defaultPartitionSuffix).partitionName(defaultPartitionName).port(port).build();
        server.start();
        return server;
    }

    public void start() {
        Assert.isTrue((this.directoryServer.getListenPort() == -1 ? 1 : 0) != 0, (String)"The server has already been started.");
        try {
            this.directoryServer.startListening();
        }
        catch (LDAPException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        this.directoryServer.shutDown(true);
    }

    @Deprecated(since="3.3")
    public void shutdown() {
        this.directoryServer.shutDown(true);
    }

    public static final class Builder {
        private final String partitionSuffix;
        private String partitionName;
        private int port = 0;
        private Consumer<InMemoryDirectoryServerConfig> configurationCustomizer = __ -> {};

        private Builder(String partitionSuffix) {
            this.partitionSuffix = partitionSuffix;
            this.partitionName = Builder.leftMostElement(partitionSuffix);
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder configurationCustomizer(Consumer<InMemoryDirectoryServerConfig> configurationCustomizer) {
            this.configurationCustomizer = configurationCustomizer;
            return this;
        }

        public Builder partitionName(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        public EmbeddedLdapServer build() {
            try {
                InMemoryDirectoryServerConfig config = Builder.inMemoryDirectoryServerConfig(this.partitionSuffix, this.port);
                this.configurationCustomizer.accept(config);
                Entry entry = Builder.ldapEntry(this.partitionName, this.partitionSuffix);
                InMemoryDirectoryServer directoryServer = Builder.inMemoryDirectoryServer(config, entry);
                return new EmbeddedLdapServer(directoryServer);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        static String leftMostElement(String partitionSuffix) {
            try {
                List<Rdn> rdns = new LdapName(partitionSuffix).getRdns();
                return ((Rdn)CollectionUtils.lastElement(rdns)).getValue().toString();
            }
            catch (InvalidNameException ex) {
                throw new RuntimeException(ex);
            }
        }

        private static InMemoryDirectoryServerConfig inMemoryDirectoryServerConfig(String partitionSuffix, int port) throws LDAPException {
            InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{partitionSuffix});
            config.addAdditionalBindCredentials("uid=admin,ou=system", "secret");
            config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"LDAP", (int)port)});
            config.setEnforceSingleStructuralObjectClass(false);
            config.setEnforceAttributeSyntaxCompliance(true);
            return config;
        }

        private static Entry ldapEntry(String defaultPartitionName, String defaultPartitionSuffix) throws LDAPException {
            Entry entry = new Entry(new DN(defaultPartitionSuffix));
            entry.addAttribute("objectClass", new String[]{"top", "domain", "extensibleObject"});
            entry.addAttribute("dc", defaultPartitionName);
            return entry;
        }

        private static InMemoryDirectoryServer inMemoryDirectoryServer(InMemoryDirectoryServerConfig config, Entry entry) throws LDAPException {
            InMemoryDirectoryServer directoryServer = new InMemoryDirectoryServer(config);
            directoryServer.add(entry);
            return directoryServer;
        }
    }
}

