/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.AuditableAccessControlEntry;
import org.springframework.util.Assert;

public class ConsoleAuditLogger
implements AuditLogger {
    @Override
    public void logIfNeeded(boolean granted, AccessControlEntry ace) {
        Assert.notNull((Object)ace, (String)"AccessControlEntry required");
        if (ace instanceof AuditableAccessControlEntry) {
            AuditableAccessControlEntry auditableAce = (AuditableAccessControlEntry)ace;
            if (granted && auditableAce.isAuditSuccess()) {
                System.out.println("GRANTED due to ACE: " + String.valueOf(ace));
            } else if (!granted && auditableAce.isAuditFailure()) {
                System.out.println("DENIED due to ACE: " + String.valueOf(ace));
            }
        }
    }
}

