/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.socket;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.configuration.ObjectPostProcessorConfiguration;
import org.springframework.security.config.annotation.web.messaging.MessageSecurityMetadataSourceRegistry;
import org.springframework.security.messaging.access.expression.DefaultMessageSecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.MessageExpressionVoter;
import org.springframework.security.messaging.access.intercept.ChannelSecurityInterceptor;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.context.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.messaging.context.SecurityContextChannelInterceptor;
import org.springframework.security.messaging.web.csrf.CsrfChannelInterceptor;
import org.springframework.security.messaging.web.socket.server.CsrfTokenHandshakeInterceptor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.springframework.web.socket.sockjs.transport.TransportHandlingSockJsService;

@Order(value=-2147483548)
@Import(value={ObjectPostProcessorConfiguration.class})
@Deprecated
public abstract class AbstractSecurityWebSocketMessageBrokerConfigurer
implements WebSocketMessageBrokerConfigurer,
SmartInitializingSingleton {
    private final WebSocketMessageSecurityMetadataSourceRegistry inboundRegistry = new WebSocketMessageSecurityMetadataSourceRegistry();
    private SecurityExpressionHandler<Message<Object>> defaultExpressionHandler = new DefaultMessageSecurityExpressionHandler();
    private SecurityExpressionHandler<Message<Object>> expressionHandler;
    private ApplicationContext context;

    public void registerStompEndpoints(StompEndpointRegistry registry) {
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver());
    }

    public final void configureClientInboundChannel(ChannelRegistration registration) {
        ChannelSecurityInterceptor inboundChannelSecurity = (ChannelSecurityInterceptor)this.context.getBean(ChannelSecurityInterceptor.class);
        registration.interceptors(new ChannelInterceptor[]{(ChannelInterceptor)this.context.getBean(SecurityContextChannelInterceptor.class)});
        if (!this.sameOriginDisabled()) {
            registration.interceptors(new ChannelInterceptor[]{(ChannelInterceptor)this.context.getBean(CsrfChannelInterceptor.class)});
        }
        if (this.inboundRegistry.containsMapping()) {
            registration.interceptors(new ChannelInterceptor[]{inboundChannelSecurity});
        }
        this.customizeClientInboundChannel(registration);
    }

    private PathMatcher getDefaultPathMatcher() {
        try {
            return ((SimpAnnotationMethodMessageHandler)this.context.getBean(SimpAnnotationMethodMessageHandler.class)).getPathMatcher();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return new AntPathMatcher();
        }
    }

    protected boolean sameOriginDisabled() {
        return false;
    }

    protected void customizeClientInboundChannel(ChannelRegistration registration) {
    }

    @Bean
    public CsrfChannelInterceptor csrfChannelInterceptor() {
        return new CsrfChannelInterceptor();
    }

    @Bean
    public ChannelSecurityInterceptor inboundChannelSecurity(MessageSecurityMetadataSource messageSecurityMetadataSource) {
        ChannelSecurityInterceptor channelSecurityInterceptor = new ChannelSecurityInterceptor(messageSecurityMetadataSource);
        MessageExpressionVoter voter = new MessageExpressionVoter();
        voter.setExpressionHandler(this.getMessageExpressionHandler());
        ArrayList<MessageExpressionVoter> voters = new ArrayList<MessageExpressionVoter>();
        voters.add(voter);
        AffirmativeBased manager = new AffirmativeBased(voters);
        channelSecurityInterceptor.setAccessDecisionManager((AccessDecisionManager)manager);
        return channelSecurityInterceptor;
    }

    @Bean
    public SecurityContextChannelInterceptor securityContextChannelInterceptor() {
        return new SecurityContextChannelInterceptor();
    }

    @Bean
    public MessageSecurityMetadataSource inboundMessageSecurityMetadataSource() {
        this.inboundRegistry.expressionHandler(this.getMessageExpressionHandler());
        this.configureInbound(this.inboundRegistry);
        return this.inboundRegistry.createMetadataSource();
    }

    protected void configureInbound(MessageSecurityMetadataSourceRegistry messages) {
    }

    @Autowired
    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Deprecated
    public void setMessageExpessionHandler(List<SecurityExpressionHandler<Message<Object>>> expressionHandlers) {
        this.setMessageExpressionHandler(expressionHandlers);
    }

    @Autowired(required=false)
    public void setMessageExpressionHandler(List<SecurityExpressionHandler<Message<Object>>> expressionHandlers) {
        if (expressionHandlers.size() == 1) {
            this.expressionHandler = expressionHandlers.get(0);
        }
    }

    @Autowired(required=false)
    public void setObjectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        this.defaultExpressionHandler = objectPostProcessor.postProcess(this.defaultExpressionHandler);
    }

    private SecurityExpressionHandler<Message<Object>> getMessageExpressionHandler() {
        if (this.expressionHandler == null) {
            return this.defaultExpressionHandler;
        }
        return this.expressionHandler;
    }

    public void afterSingletonsInstantiated() {
        if (this.sameOriginDisabled()) {
            return;
        }
        String beanName = "stompWebSocketHandlerMapping";
        SimpleUrlHandlerMapping mapping = (SimpleUrlHandlerMapping)this.context.getBean(beanName, SimpleUrlHandlerMapping.class);
        Map mappings = mapping.getHandlerMap();
        for (Object object : mappings.values()) {
            if (object instanceof SockJsHttpRequestHandler) {
                this.setHandshakeInterceptors((SockJsHttpRequestHandler)object);
                continue;
            }
            if (object instanceof WebSocketHttpRequestHandler) {
                this.setHandshakeInterceptors((WebSocketHttpRequestHandler)object);
                continue;
            }
            throw new IllegalStateException("Bean " + beanName + " is expected to contain mappings to either a SockJsHttpRequestHandler or a WebSocketHttpRequestHandler but got " + String.valueOf(object));
        }
        if (this.inboundRegistry.containsMapping() && !this.inboundRegistry.isSimpDestPathMatcherConfigured()) {
            PathMatcher pathMatcher = this.getDefaultPathMatcher();
            this.inboundRegistry.simpDestPathMatcher(pathMatcher);
        }
    }

    private void setHandshakeInterceptors(SockJsHttpRequestHandler handler) {
        SockJsService sockJsService = handler.getSockJsService();
        Assert.state((boolean)(sockJsService instanceof TransportHandlingSockJsService), () -> "sockJsService must be instance of TransportHandlingSockJsService got " + String.valueOf(sockJsService));
        TransportHandlingSockJsService transportHandlingSockJsService = (TransportHandlingSockJsService)sockJsService;
        List handshakeInterceptors = transportHandlingSockJsService.getHandshakeInterceptors();
        ArrayList<CsrfTokenHandshakeInterceptor> interceptorsToSet = new ArrayList<CsrfTokenHandshakeInterceptor>(handshakeInterceptors.size() + 1);
        interceptorsToSet.add(new CsrfTokenHandshakeInterceptor());
        interceptorsToSet.addAll(handshakeInterceptors);
        transportHandlingSockJsService.setHandshakeInterceptors(interceptorsToSet);
    }

    private void setHandshakeInterceptors(WebSocketHttpRequestHandler handler) {
        List handshakeInterceptors = handler.getHandshakeInterceptors();
        ArrayList<CsrfTokenHandshakeInterceptor> interceptorsToSet = new ArrayList<CsrfTokenHandshakeInterceptor>(handshakeInterceptors.size() + 1);
        interceptorsToSet.add(new CsrfTokenHandshakeInterceptor());
        interceptorsToSet.addAll(handshakeInterceptors);
        handler.setHandshakeInterceptors(interceptorsToSet);
    }

    private static class WebSocketMessageSecurityMetadataSourceRegistry
    extends MessageSecurityMetadataSourceRegistry {
        private WebSocketMessageSecurityMetadataSourceRegistry() {
        }

        @Override
        public MessageSecurityMetadataSource createMetadataSource() {
            return super.createMetadataSource();
        }

        @Override
        protected boolean containsMapping() {
            return super.containsMapping();
        }

        @Override
        protected boolean isSimpDestPathMatcherConfigured() {
            return super.isSimpDestPathMatcherConfigured();
        }
    }
}

