/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.PathPatternRequestMatcherFactoryBean;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public enum MatcherType {
    path(PathPatternRequestMatcher.class),
    regex(RegexRequestMatcher.class),
    ciRegex(RegexRequestMatcher.class);

    private static final String ATT_MATCHER_TYPE = "request-matcher";
    final Class<? extends RequestMatcher> type;

    private MatcherType(Class<? extends RequestMatcher> type) {
        this.type = type;
    }

    public BeanDefinition createMatcher(ParserContext pc, String path, String method) {
        return this.createMatcher(pc, path, method, null);
    }

    public BeanDefinition createMatcher(ParserContext pc, String path, String method, String servletPath) {
        BeanDefinitionBuilder matcherBldr;
        if (("/**".equals(path) || "**".equals(path)) && method == null) {
            return new RootBeanDefinition(AnyRequestMatcher.class);
        }
        if (this == MatcherType.path) {
            matcherBldr = BeanDefinitionBuilder.rootBeanDefinition(PathPatternRequestMatcherFactoryBean.class);
            matcherBldr.addConstructorArgValue((Object)path);
            matcherBldr.addPropertyValue("basePath", (Object)servletPath);
        } else {
            matcherBldr = BeanDefinitionBuilder.rootBeanDefinition(this.type);
            matcherBldr.addConstructorArgValue((Object)path);
        }
        matcherBldr.addConstructorArgValue((Object)method);
        if (this == ciRegex) {
            matcherBldr.addConstructorArgValue((Object)true);
        }
        return matcherBldr.getBeanDefinition();
    }

    static MatcherType fromElement(Element elt) {
        if (StringUtils.hasText((String)elt.getAttribute(ATT_MATCHER_TYPE))) {
            return MatcherType.valueOf(elt.getAttribute(ATT_MATCHER_TYPE));
        }
        return path;
    }

    static MatcherType fromElementOrMvc(Element elt) {
        return MatcherType.fromElement(elt);
    }
}

