/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.web.util.pattern.PathPatternParser;

public final class PathPatternRequestMatcherBuilderFactoryBean
implements FactoryBean<PathPatternRequestMatcher.Builder>,
ApplicationContextAware,
BeanNameAware,
BeanFactoryAware {
    static final String MVC_PATTERN_PARSER_BEAN_NAME = "mvcPatternParser";
    private final PathPatternParser parser;
    private String basePath;
    private ApplicationContext context;
    private String beanName;
    private ConfigurableListableBeanFactory beanFactory;

    public PathPatternRequestMatcherBuilderFactoryBean() {
        this(null);
    }

    public PathPatternRequestMatcherBuilderFactoryBean(PathPatternParser parser) {
        this.parser = parser;
    }

    public PathPatternRequestMatcher.Builder getObject() throws Exception {
        PathPatternParser parser;
        if (!this.context.containsBean(MVC_PATTERN_PARSER_BEAN_NAME)) {
            PathPatternParser parser2 = this.parser != null ? this.parser : PathPatternParser.defaultInstance;
            return this.withPathPatternParser(parser2);
        }
        PathPatternParser mvc = (PathPatternParser)this.context.getBean(MVC_PATTERN_PARSER_BEAN_NAME, PathPatternParser.class);
        PathPatternParser pathPatternParser = parser = this.parser != null ? this.parser : mvc;
        if (mvc.equals(parser)) {
            return this.withPathPatternParser(parser);
        }
        throw new IllegalArgumentException("Spring Security and Spring MVC must use the same path pattern parser. To have Spring Security use Spring MVC's [" + this.describe(mvc, MVC_PATTERN_PARSER_BEAN_NAME) + "] simply publish this bean [" + this.describe(this, this.beanName) + "] using its default constructor");
    }

    private PathPatternRequestMatcher.Builder withPathPatternParser(PathPatternParser parser) {
        if (this.basePath == null) {
            return PathPatternRequestMatcher.withPathPatternParser((PathPatternParser)parser);
        }
        return PathPatternRequestMatcher.withPathPatternParser((PathPatternParser)parser).basePath(this.basePath);
    }

    public Class<?> getObjectType() {
        return PathPatternRequestMatcher.Builder.class;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setBeanName(@NonNull String name) {
        this.beanName = name;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listable;
            this.beanFactory = listable = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    private String describe(Object bean, String name) {
        Object text = bean.getClass().getSimpleName();
        if (name == null) {
            return text;
        }
        text = (String)text + "defined as '" + name + "'";
        if (this.beanFactory == null) {
            return text;
        }
        BeanDefinition bd = this.beanFactory.getBeanDefinition(name);
        String description = bd.getResourceDescription();
        if (description == null) {
            return text;
        }
        text = (String)text + " in [" + description + "]";
        return text;
    }
}

