/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.websocket;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.vote.ConsensusBased;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.config.http.MessageMatcherFactoryBean;
import org.springframework.security.config.web.messaging.PathPatternMessageMatcherBuilderFactoryBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.messaging.access.expression.ExpressionBasedMessageSecurityMetadataSourceFactory;
import org.springframework.security.messaging.access.expression.MessageAuthorizationContextSecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.MessageExpressionVoter;
import org.springframework.security.messaging.access.intercept.AuthorizationChannelInterceptor;
import org.springframework.security.messaging.access.intercept.ChannelSecurityInterceptor;
import org.springframework.security.messaging.access.intercept.MessageAuthorizationContext;
import org.springframework.security.messaging.access.intercept.MessageMatcherDelegatingAuthorizationManager;
import org.springframework.security.messaging.context.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.messaging.context.SecurityContextChannelInterceptor;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpMessageTypeMatcher;
import org.springframework.security.messaging.web.csrf.XorCsrfChannelInterceptor;
import org.springframework.security.messaging.web.socket.server.CsrfTokenHandshakeInterceptor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class WebSocketMessageBrokerSecurityBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ID_ATTR = "id";
    private static final String DISABLED_ATTR = "same-origin-disabled";
    private static final String USE_AUTHORIZATION_MANAGER_ATTR = "use-authorization-manager";
    private static final String AUTHORIZATION_MANAGER_REF_ATTR = "authorization-manager-ref";
    private static final String SECURITY_CONTEXT_HOLDER_STRATEGY_REF_ATTR = "security-context-holder-strategy-ref";
    private static final String PATTERN_ATTR = "pattern";
    private static final String ACCESS_ATTR = "access";
    private static final String TYPE_ATTR = "type";
    private static final String MESSAGE_MATCHER_BUILDER_BEAN_NAME = "HttpConfigurationBuilder-pathPatternMessageMatcherBuilder";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String id = element.getAttribute(ID_ATTR);
        if (!parserContext.getRegistry().containsBeanDefinition(MESSAGE_MATCHER_BUILDER_BEAN_NAME)) {
            BeanDefinitionBuilder pathPatternMessageMatcherBuilder = BeanDefinitionBuilder.rootBeanDefinition(PathPatternMessageMatcherBuilderFactoryBean.class);
            pathPatternMessageMatcherBuilder.setFallback(true);
            AbstractBeanDefinition bean = pathPatternMessageMatcherBuilder.getBeanDefinition();
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bean, MESSAGE_MATCHER_BUILDER_BEAN_NAME));
        }
        String inSecurityInterceptorName = this.parseAuthorization(element, parserContext);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (StringUtils.hasText((String)id)) {
            registry.registerAlias(inSecurityInterceptorName, id);
        } else {
            boolean sameOriginDisabled = Boolean.parseBoolean(element.getAttribute(DISABLED_ATTR));
            XmlReaderContext context = parserContext.getReaderContext();
            BeanDefinitionBuilder mspp = BeanDefinitionBuilder.rootBeanDefinition(MessageSecurityPostProcessor.class);
            mspp.addConstructorArgValue((Object)inSecurityInterceptorName);
            mspp.addConstructorArgValue((Object)sameOriginDisabled);
            context.registerWithGeneratedName((BeanDefinition)mspp.getBeanDefinition());
        }
        return null;
    }

    private String parseAuthorization(Element element, ParserContext parserContext) {
        boolean useAuthorizationManager = true;
        if (StringUtils.hasText((String)element.getAttribute(USE_AUTHORIZATION_MANAGER_ATTR))) {
            useAuthorizationManager = Boolean.parseBoolean(element.getAttribute(USE_AUTHORIZATION_MANAGER_ATTR));
        }
        if (useAuthorizationManager) {
            return this.parseAuthorizationManager(element, parserContext);
        }
        if (StringUtils.hasText((String)element.getAttribute(AUTHORIZATION_MANAGER_REF_ATTR))) {
            return this.parseAuthorizationManager(element, parserContext);
        }
        return this.parseSecurityMetadataSource(element, parserContext);
    }

    private String parseAuthorizationManager(Element element, ParserContext parserContext) {
        XmlReaderContext context = parserContext.getReaderContext();
        String mdsId = this.createAuthorizationManager(element, parserContext);
        BeanDefinitionBuilder inboundChannelSecurityInterceptor = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationChannelInterceptor.class);
        inboundChannelSecurityInterceptor.addConstructorArgReference(mdsId);
        String holderStrategyRef = element.getAttribute(SECURITY_CONTEXT_HOLDER_STRATEGY_REF_ATTR);
        if (StringUtils.hasText((String)holderStrategyRef)) {
            inboundChannelSecurityInterceptor.addPropertyValue("securityContextHolderStrategy", (Object)new RuntimeBeanReference(holderStrategyRef));
        } else {
            inboundChannelSecurityInterceptor.addPropertyValue("securityContextHolderStrategy", (Object)BeanDefinitionBuilder.rootBeanDefinition(SecurityContextHolderStrategyFactory.class).getBeanDefinition());
        }
        return context.registerWithGeneratedName((BeanDefinition)inboundChannelSecurityInterceptor.getBeanDefinition());
    }

    private String createAuthorizationManager(Element element, ParserContext parserContext) {
        XmlReaderContext context = parserContext.getReaderContext();
        String authorizationManagerRef = element.getAttribute(AUTHORIZATION_MANAGER_REF_ATTR);
        if (StringUtils.hasText((String)authorizationManagerRef)) {
            return authorizationManagerRef;
        }
        Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
        String expressionHandlerRef = expressionHandlerElt != null ? expressionHandlerElt.getAttribute("ref") : null;
        ManagedMap matcherToExpression = new ManagedMap();
        List interceptMessages = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-message");
        for (Element interceptMessage : interceptMessages) {
            String matcherPattern = interceptMessage.getAttribute(PATTERN_ATTR);
            String accessExpression = interceptMessage.getAttribute(ACCESS_ATTR);
            String messageType = interceptMessage.getAttribute(TYPE_ATTR);
            BeanDefinition matcher = this.createMatcher(matcherPattern, messageType, parserContext, interceptMessage);
            BeanDefinitionBuilder authorizationManager = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedAuthorizationManager.class);
            if (StringUtils.hasText((String)expressionHandlerRef)) {
                authorizationManager.addConstructorArgReference(expressionHandlerRef);
            }
            authorizationManager.addConstructorArgValue((Object)accessExpression);
            matcherToExpression.put((Object)matcher, (Object)authorizationManager.getBeanDefinition());
        }
        BeanDefinitionBuilder mds = BeanDefinitionBuilder.rootBeanDefinition(MessageMatcherDelegatingAuthorizationManagerFactory.class);
        mds.setFactoryMethod("createMessageMatcherDelegatingAuthorizationManager");
        mds.addConstructorArgValue((Object)matcherToExpression);
        return context.registerWithGeneratedName((BeanDefinition)mds.getBeanDefinition());
    }

    private String parseSecurityMetadataSource(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        XmlReaderContext context = parserContext.getReaderContext();
        ManagedMap matcherToExpression = new ManagedMap();
        Element expressionHandlerElt = DomUtils.getChildElementByTagName((Element)element, (String)"expression-handler");
        String expressionHandlerRef = expressionHandlerElt != null ? expressionHandlerElt.getAttribute("ref") : null;
        boolean expressionHandlerDefined = StringUtils.hasText((String)expressionHandlerRef);
        List interceptMessages = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-message");
        for (Element interceptMessage : interceptMessages) {
            String matcherPattern = interceptMessage.getAttribute(PATTERN_ATTR);
            String accessExpression = interceptMessage.getAttribute(ACCESS_ATTR);
            String messageType = interceptMessage.getAttribute(TYPE_ATTR);
            BeanDefinition matcher = this.createMatcher(matcherPattern, messageType, parserContext, interceptMessage);
            matcherToExpression.put((Object)matcher, (Object)accessExpression);
        }
        BeanDefinitionBuilder mds = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedMessageSecurityMetadataSourceFactory.class);
        mds.setFactoryMethod("createExpressionMessageMetadataSource");
        mds.addConstructorArgValue((Object)matcherToExpression);
        if (expressionHandlerDefined) {
            mds.addConstructorArgReference(expressionHandlerRef);
        }
        String mdsId = context.registerWithGeneratedName((BeanDefinition)mds.getBeanDefinition());
        ManagedList voters = new ManagedList();
        BeanDefinitionBuilder messageExpressionVoterBldr = BeanDefinitionBuilder.rootBeanDefinition(MessageExpressionVoter.class);
        if (expressionHandlerDefined) {
            messageExpressionVoterBldr.addPropertyReference("expressionHandler", expressionHandlerRef);
        }
        voters.add((Object)messageExpressionVoterBldr.getBeanDefinition());
        BeanDefinitionBuilder adm = BeanDefinitionBuilder.rootBeanDefinition(ConsensusBased.class);
        adm.addConstructorArgValue((Object)voters);
        BeanDefinitionBuilder inboundChannelSecurityInterceptor = BeanDefinitionBuilder.rootBeanDefinition(ChannelSecurityInterceptor.class);
        inboundChannelSecurityInterceptor.addConstructorArgValue((Object)registry.getBeanDefinition(mdsId));
        inboundChannelSecurityInterceptor.addPropertyValue("accessDecisionManager", (Object)adm.getBeanDefinition());
        return context.registerWithGeneratedName((BeanDefinition)inboundChannelSecurityInterceptor.getBeanDefinition());
    }

    private BeanDefinition createMatcher(String matcherPattern, String messageType, ParserContext parserContext, Element interceptMessage) {
        boolean hasPattern = StringUtils.hasText((String)matcherPattern);
        boolean hasMessageType = StringUtils.hasText((String)messageType);
        if (!hasPattern) {
            BeanDefinitionBuilder matcher = BeanDefinitionBuilder.rootBeanDefinition(SimpMessageTypeMatcher.class);
            matcher.addConstructorArgValue((Object)messageType);
            return matcher.getBeanDefinition();
        }
        BeanDefinitionBuilder matcher = BeanDefinitionBuilder.rootBeanDefinition(MessageMatcherFactoryBean.class);
        matcher.addConstructorArgValue((Object)matcherPattern);
        if (hasMessageType) {
            SimpMessageType type = SimpMessageType.valueOf((String)messageType);
            matcher.addConstructorArgValue((Object)type);
            if (SimpMessageType.SUBSCRIBE != type && SimpMessageType.MESSAGE != type) {
                parserContext.getReaderContext().error("Cannot use intercept-websocket@message-type=" + messageType + " with a pattern because the type does not have a destination.", (Object)interceptMessage);
            }
        }
        return matcher.getBeanDefinition();
    }

    static class MessageSecurityPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final String WEB_SOCKET_AMMH_CLASS_NAME = "org.springframework.web.socket.messaging.WebSocketAnnotationMethodMessageHandler";
        private static final String CLIENT_INBOUND_CHANNEL_BEAN_ID = "clientInboundChannel";
        private static final String CSRF_CHANNEL_INTERCEPTOR_BEAN_ID = "csrfChannelInterceptor";
        private static final String INTERCEPTORS_PROP = "interceptors";
        private static final String CUSTOM_ARG_RESOLVERS_PROP = "customArgumentResolvers";
        private static final String TEMPLATE_EXPRESSION_BEAN_ID = "annotationExpressionTemplateDefaults";
        private static final Set<String> CSRF_HANDSHAKE_HANDLER_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.springframework.web.socket.server.support.WebSocketHttpRequestHandler", "org.springframework.web.socket.sockjs.transport.TransportHandlingSockJsService", "org.springframework.web.socket.sockjs.transport.handler.DefaultSockJsService")));
        private final String inboundSecurityInterceptorId;
        private final boolean sameOriginDisabled;

        MessageSecurityPostProcessor(String inboundSecurityInterceptorId, boolean sameOriginDisabled) {
            this.inboundSecurityInterceptorId = inboundSecurityInterceptorId;
            this.sameOriginDisabled = sameOriginDisabled;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            String[] beanNames;
            for (String beanName : beanNames = registry.getBeanDefinitionNames()) {
                BeanDefinition bd = registry.getBeanDefinition(beanName);
                String beanClassName = bd.getBeanClassName();
                if (SimpAnnotationMethodMessageHandler.class.getName().equals(beanClassName) || WEB_SOCKET_AMMH_CLASS_NAME.equals(beanClassName)) {
                    PropertyValue current = bd.getPropertyValues().getPropertyValue(CUSTOM_ARG_RESOLVERS_PROP);
                    ManagedList argResolvers = new ManagedList();
                    if (current != null) {
                        argResolvers.addAll((Collection)((ManagedList)current.getValue()));
                    }
                    RootBeanDefinition beanDefinition = new RootBeanDefinition(AuthenticationPrincipalArgumentResolver.class);
                    if (registry.containsBeanDefinition(TEMPLATE_EXPRESSION_BEAN_ID)) {
                        beanDefinition.getPropertyValues().add("templateDefaults", (Object)new RuntimeBeanReference(TEMPLATE_EXPRESSION_BEAN_ID));
                    }
                    argResolvers.add((Object)beanDefinition);
                    bd.getPropertyValues().add(CUSTOM_ARG_RESOLVERS_PROP, (Object)argResolvers);
                    continue;
                }
                if (!CSRF_HANDSHAKE_HANDLER_CLASSES.contains(beanClassName)) continue;
                this.addCsrfTokenHandshakeInterceptor(bd);
            }
            if (!registry.containsBeanDefinition(CLIENT_INBOUND_CHANNEL_BEAN_ID)) {
                return;
            }
            ManagedList interceptors = new ManagedList();
            interceptors.add((Object)new RootBeanDefinition(SecurityContextChannelInterceptor.class));
            if (!this.sameOriginDisabled) {
                if (!registry.containsBeanDefinition(CSRF_CHANNEL_INTERCEPTOR_BEAN_ID)) {
                    interceptors.add((Object)new RootBeanDefinition(XorCsrfChannelInterceptor.class));
                } else {
                    interceptors.add((Object)new RuntimeBeanReference(CSRF_CHANNEL_INTERCEPTOR_BEAN_ID));
                }
            }
            interceptors.add((Object)registry.getBeanDefinition(this.inboundSecurityInterceptorId));
            BeanDefinition inboundChannel = registry.getBeanDefinition(CLIENT_INBOUND_CHANNEL_BEAN_ID);
            PropertyValue currentInterceptorsPv = inboundChannel.getPropertyValues().getPropertyValue(INTERCEPTORS_PROP);
            if (currentInterceptorsPv != null) {
                ManagedList currentInterceptors = (ManagedList)currentInterceptorsPv.getValue();
                interceptors.addAll((Collection)currentInterceptors);
            }
            inboundChannel.getPropertyValues().add(INTERCEPTORS_PROP, (Object)interceptors);
        }

        private void addCsrfTokenHandshakeInterceptor(BeanDefinition bd) {
            if (this.sameOriginDisabled) {
                return;
            }
            String interceptorPropertyName = "handshakeInterceptors";
            ManagedList interceptors = new ManagedList();
            interceptors.add((Object)new RootBeanDefinition(CsrfTokenHandshakeInterceptor.class));
            interceptors.addAll((Collection)((ManagedList)bd.getPropertyValues().get(interceptorPropertyName)));
            bd.getPropertyValues().add(interceptorPropertyName, (Object)interceptors);
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }

    static class SecurityContextHolderStrategyFactory
    implements FactoryBean<SecurityContextHolderStrategy> {
        SecurityContextHolderStrategyFactory() {
        }

        public SecurityContextHolderStrategy getObject() throws Exception {
            return SecurityContextHolder.getContextHolderStrategy();
        }

        public Class<?> getObjectType() {
            return SecurityContextHolderStrategy.class;
        }
    }

    private static final class ExpressionBasedAuthorizationManager
    implements AuthorizationManager<MessageAuthorizationContext<?>> {
        private final SecurityExpressionHandler<MessageAuthorizationContext<?>> expressionHandler;
        private final Expression expression;

        private ExpressionBasedAuthorizationManager(String expression) {
            this((SecurityExpressionHandler<MessageAuthorizationContext<?>>)new MessageAuthorizationContextSecurityExpressionHandler(), expression);
        }

        private ExpressionBasedAuthorizationManager(SecurityExpressionHandler<MessageAuthorizationContext<?>> expressionHandler, String expression) {
            Assert.notNull(expressionHandler, (String)"expressionHandler cannot be null");
            Assert.notNull((Object)expression, (String)"expression cannot be null");
            this.expressionHandler = expressionHandler;
            this.expression = this.expressionHandler.getExpressionParser().parseExpression(expression);
        }

        public AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> authentication, MessageAuthorizationContext<?> object) {
            EvaluationContext context = this.expressionHandler.createEvaluationContext(authentication, object);
            boolean granted = ExpressionUtils.evaluateAsBoolean((Expression)this.expression, (EvaluationContext)context);
            return new AuthorizationDecision(granted);
        }
    }

    private static class MessageMatcherDelegatingAuthorizationManagerFactory {
        private MessageMatcherDelegatingAuthorizationManagerFactory() {
        }

        private static AuthorizationManager<Message<?>> createMessageMatcherDelegatingAuthorizationManager(Map<MessageMatcher<?>, AuthorizationManager<MessageAuthorizationContext<?>>> beans) {
            MessageMatcherDelegatingAuthorizationManager.Builder builder = MessageMatcherDelegatingAuthorizationManager.builder();
            for (Map.Entry<MessageMatcher<?>, AuthorizationManager<MessageAuthorizationContext<?>>> entry : beans.entrySet()) {
                builder.matchers(new MessageMatcher[]{entry.getKey()}).access(entry.getValue());
            }
            return builder.anyMessage().permitAll().build();
        }
    }

    static class DelegatingPathMatcher
    implements PathMatcher {
        private PathMatcher delegate = new AntPathMatcher();

        DelegatingPathMatcher() {
        }

        public boolean isPattern(String path) {
            return this.delegate.isPattern(path);
        }

        public boolean match(String pattern, String path) {
            return this.delegate.match(pattern, path);
        }

        public boolean matchStart(String pattern, String path) {
            return this.delegate.matchStart(pattern, path);
        }

        public String extractPathWithinPattern(String pattern, String path) {
            return this.delegate.extractPathWithinPattern(pattern, path);
        }

        public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
            return this.delegate.extractUriTemplateVariables(pattern, path);
        }

        public Comparator<String> getPatternComparator(String path) {
            return this.delegate.getPatternComparator(path);
        }

        public String combine(String pattern1, String pattern2) {
            return this.delegate.combine(pattern1, pattern2);
        }

        void setPathMatcher(PathMatcher pathMatcher) {
            this.delegate = pathMatcher;
        }
    }
}

