/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.accept.ApiVersionDeprecationHandler;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.accept.SemanticApiVersionParser;

public class StandardApiVersionDeprecationHandler
implements ApiVersionDeprecationHandler {
    private final ApiVersionParser<?> versionParser;
    private final Map<Comparable<?>, VersionInfo> infos = new HashMap();

    public StandardApiVersionDeprecationHandler() {
        this(new SemanticApiVersionParser());
    }

    public StandardApiVersionDeprecationHandler(ApiVersionParser<?> parser) {
        this.versionParser = parser;
    }

    public VersionSpec configureVersion(String version) {
        Object parsedVersion = this.versionParser.parseVersion(version);
        return new VersionSpec((Comparable<?>)parsedVersion);
    }

    @Override
    public void handleVersion(Comparable<?> requestVersion, HttpServletRequest request, HttpServletResponse response) {
        for (VersionInfo info : this.infos.values()) {
            if (!info.match(requestVersion, request)) continue;
            if (info.deprecationDate() != null) {
                response.setHeader("Deprecation", info.deprecationDate());
            }
            if (info.deprecationLink() != null) {
                response.addHeader("Link", info.deprecationLink());
            }
            if (info.sunsetDate() != null) {
                response.setHeader("Sunset", info.sunsetDate());
            }
            if (info.sunsetLink() == null) continue;
            response.addHeader("Link", info.sunsetLink());
        }
    }

    public String toString() {
        return "StandardApiVersionDeprecationHandler " + String.valueOf(this.infos.values());
    }

    public final class VersionSpec {
        private final Comparable<?> version;

        private VersionSpec(Comparable<?> version) {
            this.version = version;
            StandardApiVersionDeprecationHandler.this.infos.put(version, new VersionInfo(version));
        }

        public VersionSpec setRequestPredicate(Predicate<HttpServletRequest> predicate) {
            return this.map(info -> info.withRequestPredicate(predicate));
        }

        public VersionSpec setDeprecationDate(ZonedDateTime date) {
            return this.map(info -> info.withDeprecationDate(date));
        }

        public VersionSpec setDeprecationLink(URI uri) {
            return this.setDeprecationLink(uri, MediaType.TEXT_HTML);
        }

        public VersionSpec setDeprecationLink(URI uri, MediaType mediaType) {
            return this.map(info -> info.withDeprecationLink(uri, mediaType));
        }

        public VersionSpec setSunsetDate(ZonedDateTime date) {
            return this.map(info -> info.withSunsetDate(date));
        }

        public VersionSpec setSunsetLink(URI uri) {
            return this.setSunsetLink(uri, MediaType.TEXT_HTML);
        }

        public VersionSpec setSunsetLink(URI uri, MediaType mediaType) {
            return this.map(info -> info.withSunsetLink(uri, mediaType));
        }

        private VersionSpec map(Function<VersionInfo, VersionInfo> function) {
            StandardApiVersionDeprecationHandler.this.infos.compute(this.version, (version, versionInfo) -> {
                Assert.state((versionInfo != null ? 1 : 0) != 0, (String)"No VersionInfo");
                return (VersionInfo)function.apply((VersionInfo)versionInfo);
            });
            return this;
        }
    }

    private record VersionInfo(Comparable<?> version, Predicate<HttpServletRequest> requestPredicate, @Nullable String deprecationDate, @Nullable String deprecationLink, @Nullable String sunsetDate, @Nullable String sunsetLink) {
        VersionInfo(Comparable<?> version) {
            this(version, request -> true, null, null, null, null);
        }

        public VersionInfo withRequestPredicate(Predicate<HttpServletRequest> predicate) {
            return new VersionInfo(this.version(), predicate, this.deprecationDate(), this.deprecationLink(), this.sunsetDate(), this.sunsetLink());
        }

        public VersionInfo withDeprecationDate(ZonedDateTime deprecationDate) {
            return new VersionInfo(this.version(), this.requestPredicate(), "@" + deprecationDate.toInstant().getEpochSecond(), this.deprecationLink(), this.sunsetDate(), this.sunsetLink());
        }

        public VersionInfo withDeprecationLink(URI uri, MediaType mediaType) {
            return new VersionInfo(this.version(), this.requestPredicate(), this.deprecationDate(), String.format("<%s>; rel=\"deprecation\"; type=\"%s\"", uri, mediaType), this.sunsetDate(), this.sunsetLink());
        }

        public VersionInfo withSunsetDate(ZonedDateTime sunsetDate) {
            return new VersionInfo(this.version(), this.requestPredicate(), this.deprecationDate(), this.deprecationLink(), sunsetDate.format(DateTimeFormatter.RFC_1123_DATE_TIME), this.sunsetLink());
        }

        public VersionInfo withSunsetLink(URI uri, MediaType mediaType) {
            return new VersionInfo(this.version(), this.requestPredicate(), this.deprecationDate(), this.deprecationLink(), this.sunsetDate(), String.format("<%s>; rel=\"sunset\"; type=\"%s\"", uri, mediaType));
        }

        boolean match(Comparable<?> requestVersion, HttpServletRequest request) {
            return this.version().equals(requestVersion) && this.requestPredicate().test(request);
        }
    }
}

