/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.boot.actuate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.statemachine.boot.actuate.StateMachineTrace;
import org.springframework.statemachine.boot.actuate.StateMachineTraceRepository;

public class InMemoryStateMachineTraceRepository
implements StateMachineTraceRepository {
    private int capacity = 100;
    private boolean reverse = true;
    private final List<StateMachineTrace> traces = new LinkedList<StateMachineTrace>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReverse(boolean reverse) {
        List<StateMachineTrace> list = this.traces;
        synchronized (list) {
            this.reverse = reverse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        List<StateMachineTrace> list = this.traces;
        synchronized (list) {
            this.capacity = capacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StateMachineTrace> findAll() {
        List<StateMachineTrace> list = this.traces;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<StateMachineTrace>(this.traces));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Map<String, Object> map) {
        StateMachineTrace trace = new StateMachineTrace(new Date(), map);
        List<StateMachineTrace> list = this.traces;
        synchronized (list) {
            while (this.traces.size() >= this.capacity) {
                this.traces.remove(this.reverse ? this.capacity - 1 : 0);
            }
            if (this.reverse) {
                this.traces.add(0, trace);
            } else {
                this.traces.add(trace);
            }
        }
    }
}

