/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.client.SMTPException;
import org.subethamail.smtp.io.ExtraDotOutputStream;

public class SMTPClient {
    private static Logger log = LoggerFactory.getLogger(SMTPClient.class);
    String hostPort;
    Socket socket;
    BufferedReader reader;
    OutputStream rawOutput;
    ExtraDotOutputStream dataOutput;
    PrintWriter writer;

    public SMTPClient(String host, int port) throws UnknownHostException, IOException {
        this(host, port, null);
    }

    public SMTPClient(String host, int port, SocketAddress bindpoint) throws UnknownHostException, IOException {
        this.hostPort = host + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug("Connecting to " + this.hostPort);
        }
        this.socket = new Socket();
        this.socket.bind(bindpoint);
        this.socket.connect(new InetSocketAddress(host, port));
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.rawOutput = this.socket.getOutputStream();
        this.dataOutput = new ExtraDotOutputStream(this.rawOutput);
        this.writer = new PrintWriter(this.rawOutput, true);
    }

    public String getHostPort() {
        return this.hostPort;
    }

    protected void send(String msg) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Client: " + msg);
        }
        this.writer.print(msg + "\r\n");
        this.writer.flush();
    }

    protected Response receive() throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = null;
        boolean done = false;
        while (!done) {
            line = this.reader.readLine();
            if (log.isDebugEnabled()) {
                log.debug("Server: " + line);
            }
            builder.append(line.substring(4));
            if (line.charAt(3) == '-') {
                builder.append('\n');
                continue;
            }
            done = true;
        }
        String code = line.substring(0, 3);
        return new Response(Integer.parseInt(code), builder.toString());
    }

    public Response sendReceive(String msg) throws IOException {
        this.send(msg);
        return this.receive();
    }

    public void receiveAndCheck() throws IOException, SMTPException {
        Response resp = this.receive();
        if (!resp.isSuccess()) {
            throw new SMTPException(resp);
        }
    }

    public void sendAndCheck(String msg) throws IOException, SMTPException {
        this.send(msg);
        this.receiveAndCheck();
    }

    public void close() {
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
                if (log.isDebugEnabled()) {
                    log.debug("Closed connection to " + this.hostPort);
                }
            }
            catch (IOException ex) {
                log.error("Problem closing connection to " + this.hostPort, (Throwable)ex);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.hostPort + "}";
    }

    public static class Response {
        int code;
        String message;

        public Response(int code, String text) {
            this.code = code;
            this.message = text;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this.code >= 100 && this.code < 400;
        }

        public String toString() {
            return this.code + " " + this.message;
        }
    }
}

