/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.ext;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.ext.ScriptScanner;

class ScriptSplitter {
    private final ScriptScanner scanner;
    private final List<String> statements;
    private final StringBuilder sb = new StringBuilder();

    void split() {
        ScriptScanner.Lexem l;
        block6: while ((l = this.scanner.next()) != ScriptScanner.Lexem.EOF) {
            switch (l) {
                case SEPARATOR: {
                    this.flushStringBuilder();
                    continue block6;
                }
                case COMMENT: {
                    continue block6;
                }
                case WHITESPACE: {
                    if (this.sb.toString().endsWith(" ")) continue block6;
                    this.sb.append(' ');
                    continue block6;
                }
                case IDENTIFIER: {
                    this.appendMatch();
                    if (!"begin".equalsIgnoreCase(this.scanner.getCurrentMatch())) continue block6;
                    this.compoundStatement(false);
                    this.flushStringBuilder();
                    continue block6;
                }
            }
            this.appendMatch();
        }
        this.flushStringBuilder();
    }

    private void compoundStatement(boolean recursive) {
        ScriptScanner.Lexem l;
        while ((l = this.scanner.next()) != ScriptScanner.Lexem.EOF) {
            this.appendMatch();
            if (!ScriptScanner.Lexem.IDENTIFIER.equals((Object)l)) continue;
            if ("begin".equalsIgnoreCase(this.scanner.getCurrentMatch())) {
                this.compoundStatement(true);
                continue;
            }
            if (!"end".equalsIgnoreCase(this.scanner.getCurrentMatch()) || !this.endOfBlock(recursive)) continue;
            return;
        }
        this.flushStringBuilder();
    }

    private boolean endOfBlock(boolean recursive) {
        ScriptScanner.Lexem l;
        StringBuilder temporary = new StringBuilder();
        block4: while ((l = this.scanner.next()) != ScriptScanner.Lexem.EOF) {
            switch (l) {
                case COMMENT: 
                case WHITESPACE: {
                    temporary.append(this.scanner.getCurrentMatch());
                    continue block4;
                }
                case SEPARATOR: {
                    if (recursive) {
                        this.sb.append((CharSequence)temporary);
                        this.appendMatch();
                    }
                    return true;
                }
            }
            if (";".equals(this.scanner.getCurrentMatch())) {
                if (recursive) {
                    this.sb.append((CharSequence)temporary);
                }
                this.appendMatch();
                return true;
            }
            this.sb.append((CharSequence)temporary);
            this.appendMatch();
            return false;
        }
        return true;
    }

    private void appendMatch() {
        this.sb.append(this.scanner.getCurrentMatch());
    }

    private void flushStringBuilder() {
        String s = this.sb.toString().trim();
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            this.statements.add(s);
        }
        this.sb.setLength(0);
    }

    public ScriptSplitter(ScriptScanner scanner, List<String> statements) {
        this.scanner = scanner;
        this.statements = statements;
    }
}

