import { EventListenerInterface, FieldConfigInterface, FieldRuleInterface, GlobalConfigInterface, GroupFieldInterface, GroupFieldsInterface, GroupRuleInterface, GroupRules, Rules, FieldsInterface, LocaleInterface, TooltipPositionType, TooltipInstance, ElemValueType, CustomMessageFuncType, ShowLabelsInterface, FieldRuleValueType, FieldSelectorType } from './modules/interfaces';
declare class JustValidate {
    form: HTMLFormElement | null;
    fields: FieldsInterface;
    groupFields: GroupFieldsInterface;
    errors: {
        [key: string]: {
            message?: string;
        };
    };
    isValid: boolean;
    isSubmitted: boolean;
    globalConfig: GlobalConfigInterface;
    errorLabels: {
        [name: string]: HTMLDivElement;
    };
    successLabels: {
        [name: string]: HTMLDivElement;
    };
    eventListeners: EventListenerInterface[];
    dictLocale: LocaleInterface[];
    currentLocale: string;
    customStyleTags: {
        [id: string]: HTMLStyleElement;
    };
    onSuccessCallback?: (event?: Event) => void;
    onFailCallback?: (fields: FieldsInterface, groups: GroupFieldsInterface) => void;
    tooltips: TooltipInstance[];
    lastScrollPosition?: number;
    isScrollTick?: boolean;
    fieldIds: Map<FieldSelectorType, string>;
    constructor(form: string | Element, globalConfig?: Partial<GlobalConfigInterface>, dictLocale?: LocaleInterface[]);
    initialize(form: string | Element, globalConfig?: Partial<GlobalConfigInterface>, dictLocale?: LocaleInterface[]): void;
    getKeyByFieldSelector: (field: FieldSelectorType) => string | undefined;
    getFieldSelectorByKey: (key: string) => FieldSelectorType | undefined;
    setKeyByFieldSelector: (field: FieldSelectorType) => string;
    refreshAllTooltips: () => void;
    handleDocumentScroll: () => void;
    getLocalisedString(rule?: Rules | GroupRules, ruleValue?: FieldRuleValueType, customMsg?: string): string;
    getFieldErrorMessage(fieldRule: FieldRuleInterface, elem: HTMLInputElement): string;
    getFieldSuccessMessage(successMessage: string | CustomMessageFuncType, elem: HTMLInputElement): string | undefined;
    getGroupErrorMessage(groupRule: GroupRuleInterface): string;
    getGroupSuccessMessage(groupRule: GroupRuleInterface): string | undefined;
    setFieldInvalid(key: string, fieldRule: FieldRuleInterface): void;
    setFieldValid(key: string, successMessage?: string | CustomMessageFuncType): void;
    setGroupInvalid(key: string, groupRule: GroupRuleInterface): void;
    setGroupValid(key: string, groupRule: GroupRuleInterface): void;
    getElemValue(elem: HTMLInputElement): ElemValueType;
    validateGroupRule(key: string, elems: HTMLInputElement[], groupRule: GroupRuleInterface): Promise<any> | void;
    validateFieldRule(key: string, elem: HTMLInputElement, fieldRule: FieldRuleInterface, afterInputChanged?: boolean): Promise<any> | void;
    validateField(key: string, afterInputChanged?: boolean): Promise<any>;
    revalidateField(fieldSelector: FieldSelectorType): Promise<boolean>;
    validateGroup(key: string, group: GroupFieldInterface): Promise<any> | void;
    focusInvalidField(): void;
    afterSubmitValidation(forceRevalidation?: boolean): void;
    validate(forceRevalidation?: boolean): Promise<any>;
    revalidate(): Promise<boolean>;
    validateHandler(ev?: Event, forceRevalidation?: boolean): Promise<any>;
    formSubmitHandler: (ev: Event) => void;
    setForm(form: HTMLFormElement): void;
    handleFieldChange: (target: HTMLInputElement) => void;
    handleGroupChange: (target: HTMLInputElement) => void;
    handlerChange: (ev: Event) => void;
    addListener(type: string, elem: HTMLInputElement | Document | HTMLFormElement, handler: (ev: Event) => void): void;
    removeListener(type: string, elem: HTMLInputElement | Document | HTMLFormElement, handler: (ev: Event) => void): void;
    addField(fieldSelector: FieldSelectorType, rules: FieldRuleInterface[], config?: FieldConfigInterface): JustValidate;
    removeField(fieldSelector: FieldSelectorType): JustValidate;
    removeGroup(group: string): JustValidate;
    addRequiredGroup(groupField: string, errorMessage?: string, config?: FieldConfigInterface, successMessage?: string): JustValidate;
    getListenerType(type: string): 'change' | 'input' | 'keyup';
    setListeners(elem: HTMLInputElement): void;
    clearFieldLabel(key: string): void;
    clearFieldStyle(key: string): void;
    clearErrors(): void;
    isTooltip(): boolean;
    lockForm(): void;
    unlockForm(): void;
    renderTooltip(elem: HTMLElement, errorLabel: HTMLDivElement, position?: TooltipPositionType): TooltipInstance;
    createErrorLabelElem(key: string, errorMessage: string, config?: FieldConfigInterface): HTMLDivElement;
    createSuccessLabelElem(key: string, successMessage?: string, config?: FieldConfigInterface): HTMLDivElement | null;
    renderErrorsContainer(label: HTMLDivElement, errorsContainer?: string | null | Element): boolean;
    renderGroupLabel(elem: HTMLElement, label: HTMLDivElement, errorsContainer?: string | null | Element, isSuccess?: boolean): void;
    renderFieldLabel(elem: HTMLInputElement, label: HTMLDivElement, errorsContainer?: string | null | Element, isSuccess?: boolean): void;
    showLabels(fields: ShowLabelsInterface, isError: boolean): void;
    showErrors(fields: ShowLabelsInterface): void;
    showSuccessLabels(fields: ShowLabelsInterface): void;
    renderFieldError(key: string, message?: string): void;
    renderGroupError(key: string): void;
    renderErrors(forceRevalidation?: boolean): void;
    destroy(): void;
    refresh(): void;
    setCurrentLocale(locale?: string): void;
    onSuccess(callback: (ev?: Event) => void): JustValidate;
    onFail(callback: (fields: FieldsInterface, groups: GroupFieldsInterface) => void): JustValidate;
}
export default JustValidate;
export * from './modules/interfaces';
