/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.idm.Account;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronAccount
implements Account {
    private final SecurityIdentity securityIdentity;
    private final Set<String> roles;

    ElytronAccount(SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        this.securityIdentity = securityIdentity;
        this.roles = Collections.unmodifiableSet(StreamSupport.stream(securityIdentity.getRoles().spliterator(), true).collect(Collectors.toSet()));
    }

    public Principal getPrincipal() {
        return this.securityIdentity.getPrincipal();
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }
}

