/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.ethlo.time;

import java.time.ZoneOffset;
import java.util.Objects;

public class TimezoneOffset {
    public static final TimezoneOffset UTC = new TimezoneOffset(0, 0);
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private final int hours;
    private final int minutes;

    private TimezoneOffset(int hours, int minutes) {
        this.hours = hours;
        this.minutes = minutes;
    }

    public static TimezoneOffset ofHoursMinutes(int hours, int minutes) {
        return new TimezoneOffset(hours, minutes);
    }

    public static TimezoneOffset ofTotalSeconds(int seconds) {
        int absHours = seconds / 3600;
        int absMinutes = seconds / 60 % 60;
        return TimezoneOffset.ofHoursMinutes(absHours, absMinutes);
    }

    public static TimezoneOffset of(ZoneOffset offset) {
        int seconds = offset.getTotalSeconds();
        int hours = seconds / 3600;
        int remainder = seconds % 3600;
        int minutes = remainder / 60;
        return TimezoneOffset.ofHoursMinutes(hours, minutes);
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getTotalSeconds() {
        return this.hours * 60 * 60 + this.minutes * 60;
    }

    public ZoneOffset toZoneOffset() {
        if (this.equals(UTC)) {
            return ZoneOffset.UTC;
        }
        return ZoneOffset.ofHoursMinutes(this.hours, this.minutes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimezoneOffset that = (TimezoneOffset)o;
        return this.hours == that.hours && this.minutes == that.minutes;
    }

    public int hashCode() {
        return Objects.hash(this.hours, this.minutes);
    }

    public String toString() {
        return "TimezoneOffset{hours=" + this.hours + ", minutes=" + this.minutes + '}';
    }

    public int getRequiredLength() {
        return this == UTC ? 1 : 6;
    }
}

