/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jspecify.annotations.Nullable;
import org.openpdf.text.BadElementException;
import org.openpdf.text.Image;
import org.openpdf.text.Rectangle;
import org.openpdf.text.pdf.PdfReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.Size;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.PDFAsImage;
import org.xhtmlrenderer.pdf.SvgImage;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.ContentTypeDetectingInputStreamWrapper;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class ITextUserAgent
extends NaiveUserAgent {
    private static final Logger log = LoggerFactory.getLogger(ITextUserAgent.class);
    private static final int IMAGE_CACHE_CAPACITY = 32;
    private final ITextOutputDevice _outputDevice;
    private final int dotsPerPixel;

    public ITextUserAgent(ITextOutputDevice outputDevice, int dotsPerPixel) {
        super(Configuration.valueAsInt((String)"xr.image.cache-capacity", (int)32));
        this._outputDevice = outputDevice;
        this.dotsPerPixel = dotsPerPixel;
    }

    int getDotsPerPixel() {
        return this.dotsPerPixel;
    }

    public ImageResource getImageResource(String uriStr) {
        ImageResource resource;
        String unresolvedUri = uriStr;
        if (!ImageUtil.isEmbeddedBase64Image((String)uriStr)) {
            uriStr = this.resolveURI(uriStr);
        }
        if ((resource = (ImageResource)this._imageCache.get(unresolvedUri)) == null) {
            resource = this.loadImageResource(uriStr);
            this._imageCache.put(unresolvedUri, resource);
        }
        if (resource != null) {
            FSImage image = this.makeSafeCopy(resource.getImage());
            return new ImageResource(resource.getImageUri(), image);
        }
        return new ImageResource(uriStr, null);
    }

    private @Nullable FSImage makeSafeCopy(@Nullable FSImage image) {
        FSImage fSImage;
        if (image instanceof ITextFSImage) {
            ITextFSImage mutable = (ITextFSImage)image;
            fSImage = (FSImage)mutable.clone();
        } else {
            fSImage = image;
        }
        return fSImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable ImageResource loadImageResource(String uriStr) {
        if (ImageUtil.isEmbeddedBase64Image((String)uriStr)) {
            return this.loadEmbeddedBase64ImageResource(uriStr);
        }
        try (ContentTypeDetectingInputStreamWrapper cis = ContentTypeDetectingInputStreamWrapper.detectContentType((InputStream)this.resolveAndOpenStream(uriStr));){
            if (cis == null) return null;
            if (cis.isPdf()) {
                URI uri = new URI(uriStr);
                PdfReader reader = this._outputDevice.getReader(uri);
                Rectangle rect = reader.getPageSizeWithRotation(1);
                float initialWidth = rect.getWidth() * this._outputDevice.getDotsPerPoint();
                float initialHeight = rect.getHeight() * this._outputDevice.getDotsPerPoint();
                PDFAsImage image = new PDFAsImage(uri, initialWidth, initialHeight);
                ImageResource imageResource = new ImageResource(uriStr, (FSImage)image);
                return imageResource;
            }
            if (cis.isSvg()) {
                SvgImage image = this.readCsv(uriStr, (InputStream)cis);
                ImageResource imageResource = new ImageResource(uriStr, (FSImage)image);
                return imageResource;
            }
            Image image = Image.getInstance((byte[])IOUtil.readBytes((InputStream)cis));
            this.scaleToOutputResolution(image);
            ImageResource imageResource = new ImageResource(uriStr, (FSImage)new ITextFSImage(image));
            return imageResource;
        }
        catch (TranscoderException e) {
            log.error("Could not load SVG image from '{}'", (Object)uriStr, (Object)e);
            XRLog.exception((String)"Could not load image from '%s'".formatted(uriStr), (Throwable)e);
            return null;
        }
        catch (IOException | URISyntaxException | BadElementException e) {
            log.warn("Could not load image from '{}'", (Object)uriStr, (Object)e);
            XRLog.exception((String)"Could not load image from '%s'".formatted(uriStr), (Throwable)e);
        }
        return null;
    }

    private ImageResource loadEmbeddedBase64ImageResource(String uri) {
        try {
            byte[] bytes = Objects.requireNonNull(ImageUtil.getEmbeddedBase64Image((String)uri));
            Image image = Image.getInstance((byte[])bytes);
            this.scaleToOutputResolution(image);
            return new ImageResource(uri, (FSImage)new ITextFSImage(image));
        }
        catch (IOException | BadElementException e) {
            XRLog.exception((String)("Can't read embedded base64 image from " + uri), (Throwable)e);
            return new ImageResource(null, null);
        }
    }

    private SvgImage readCsv(String uri, InputStream in) throws IOException, TranscoderException {
        byte[] svgBytes = IOUtil.readBytes((InputStream)in);
        return new SvgImage(svgBytes, this.getOriginalSvgSize(uri, svgBytes), uri);
    }

    Size getOriginalSvgSize(String uri, byte[] svgImage) throws IOException {
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
        try (ByteArrayInputStream in = new ByteArrayInputStream(svgImage);){
            Document document = factory.createDocument(uri, (InputStream)in);
            String width = document.getDocumentElement().getAttribute("width");
            String height = document.getDocumentElement().getAttribute("height");
            if (!width.isEmpty() && !height.isEmpty()) {
                Size size = new Size(Integer.parseInt(width), Integer.parseInt(height));
                return size;
            }
            String[] viewBox = document.getDocumentElement().getAttribute("viewBox").split(" ", 4);
            if (viewBox.length >= 4) {
                Size size = new Size(Integer.parseInt(viewBox[2]), Integer.parseInt(viewBox[3]));
                return size;
            }
            Size size = new Size(300, 150);
            return size;
        }
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this.dotsPerPixel;
        if (factor != 1.0f) {
            image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
        }
    }
}

