/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.impl;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.common.util.ParamUtil;
import org.xipki.ocsp.server.impl.type.ResponderID;
import org.xipki.ocsp.server.impl.type.TaggedCertSequence;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgoType;

class ResponderSigner {
    private final Map<String, ConcurrentContentSigner> algoSignerMap;
    private final List<ConcurrentContentSigner> signers;
    private final TaggedCertSequence sequenceOfCertificate;
    private final X509Certificate certificate;
    private final TaggedCertSequence sequenceOfCertificateChain;
    private final X509Certificate[] certificateChain;
    private final ResponderID responderIdByName;
    private final ResponderID responderIdByKey;
    private final boolean macSigner;

    ResponderSigner(List<ConcurrentContentSigner> signers) throws CertificateException, IOException {
        this.signers = ParamUtil.requireNonEmpty((String)"signers", signers);
        ConcurrentContentSigner firstSigner = signers.get(0);
        this.macSigner = firstSigner.isMac();
        if (this.macSigner) {
            this.responderIdByName = null;
            this.certificate = null;
            this.certificateChain = null;
            this.sequenceOfCertificate = null;
            this.sequenceOfCertificateChain = null;
            byte[] keySha1 = firstSigner.getSha1DigestOfMacKey();
            this.responderIdByKey = new ResponderID(keySha1);
        } else {
            X509Certificate cert;
            X509Certificate[] tmpCertificateChain = firstSigner.getCertificateChain();
            if (tmpCertificateChain == null || tmpCertificateChain.length == 0) {
                throw new CertificateException("no certificate is bound with the signer");
            }
            int len = tmpCertificateChain.length;
            if (len > 1 && (cert = tmpCertificateChain[len - 1]).getIssuerX500Principal().equals(cert.getSubjectX500Principal())) {
                --len;
            }
            this.certificateChain = new X509Certificate[len];
            System.arraycopy(tmpCertificateChain, 0, this.certificateChain, 0, len);
            this.certificate = this.certificateChain[0];
            byte[] encodedCertificate = this.certificate.getEncoded();
            Certificate bcCertificate = Certificate.getInstance((Object)encodedCertificate);
            this.sequenceOfCertificate = new TaggedCertSequence(encodedCertificate);
            byte[][] encodedCertificateChain = new byte[this.certificateChain.length][];
            encodedCertificateChain[0] = encodedCertificate;
            for (int i = 1; i < this.certificateChain.length; ++i) {
                encodedCertificateChain[i] = this.certificateChain[i].getEncoded();
            }
            this.sequenceOfCertificateChain = new TaggedCertSequence(encodedCertificateChain);
            this.responderIdByName = new ResponderID(bcCertificate.getSubject());
            byte[] keySha1 = HashAlgoType.SHA1.hash(bcCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes());
            this.responderIdByKey = new ResponderID(keySha1);
        }
        this.algoSignerMap = new HashMap<String, ConcurrentContentSigner>();
        for (ConcurrentContentSigner signer : signers) {
            String algoName = signer.getAlgorithmName();
            this.algoSignerMap.put(algoName, signer);
        }
    }

    public boolean isMacSigner() {
        return this.macSigner;
    }

    public ConcurrentContentSigner firstSigner() {
        return this.signers.get(0);
    }

    public ConcurrentContentSigner getSignerForPreferredSigAlgs(List<AlgorithmIdentifier> prefSigAlgs) {
        if (prefSigAlgs == null) {
            return this.signers.get(0);
        }
        for (AlgorithmIdentifier sigAlgId : prefSigAlgs) {
            String algoName = ResponderSigner.getSignatureAlgorithmName(sigAlgId);
            if (!this.algoSignerMap.containsKey(algoName)) continue;
            return this.algoSignerMap.get(algoName);
        }
        return null;
    }

    public ResponderID getResponderId(boolean byName) {
        return byName ? this.responderIdByName : this.responderIdByKey;
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public X509Certificate[] certificateChain() {
        return this.certificateChain;
    }

    public TaggedCertSequence sequenceOfCertificate() {
        return this.sequenceOfCertificate;
    }

    public TaggedCertSequence sequenceOfCertificateChain() {
        return this.sequenceOfCertificateChain;
    }

    public boolean isHealthy() {
        for (ConcurrentContentSigner signer : this.signers) {
            if (signer.isHealthy()) continue;
            return false;
        }
        return true;
    }

    private static String getSignatureAlgorithmName(AlgorithmIdentifier sigAlgId) {
        ASN1ObjectIdentifier algOid = sigAlgId.getAlgorithm();
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)algOid)) {
            return algOid.getId();
        }
        ASN1Encodable asn1Encodable = sigAlgId.getParameters();
        RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)asn1Encodable);
        ASN1ObjectIdentifier digestAlgOid = param.getHashAlgorithm().getAlgorithm();
        return digestAlgOid.getId() + "WITHRSAANDMGF1";
    }
}

